<?php
// debug_zarinpal_req.php
ini_set('display_errors', 1);
error_reporting(E_ALL);

echo "<h1>Zarinpal API Request Test</h1>";

// مسیرهای صحیح برای لود کردن سرویس‌ها (فرض بر این است که فایل در ریشه قرار دارد)
require_once __DIR__ . '/config.php';
require_once __DIR__ . '/src/Database/Connection.php';
require_once __DIR__ . '/src/Services/ZarinpalService.php';
require_once __DIR__ . '/src/Utils/GeneralHelpers.php';
require_once __DIR__ . '/src/Database/OrderQueries.php'; 
require_once __DIR__ . '/src/Database/UserQueries.php'; 

echo "<h2>2. Calling Zarinpal API...</h2>";

// --- داده‌های تستی (با مبلغ واقعی بالای 100 تومان) ---
$test_amount_toman = '5000'; 
$test_order_id = 9999; 
$test_callback = ZARINPAL_CALLBACK_URL . "?order_id={$test_order_id}";

// محاسبه و تبدیل به ریال
$amount_rial = (int) bcmul($test_amount_toman, '10', 0);
$test_mobile = '09121112233'; 

try {
    // فراخوانی تابع پرداخت با پارامترهای صحیح (رفع خطای آرگومان ۴)
    $result = requestZarinpalPayment(
        $amount_rial,
        "تست شبکه و مرچنت کد در BOT.KHZAESFRRON.IR",
        $test_callback,
        [], // آرگومان ۴: Metadata (آرایه خالی)
        $test_mobile 
    );

    echo "<h3>✅ RESULT: RAW RESPONSE</h3>";
    echo "<pre>";
    print_r($result);
    echo "</pre>";

    if ($result['success']) {
        echo "<h4 style='color:green'>SUCCESS! اتصال شبکه سالم است.</h4>";
        echo "<p>Authority Code: <b>" . htmlspecialchars($result['authority']) . "</b></p>";
        echo "<p>Next Step (Manual Check): <a href='" . htmlspecialchars($result['url']) . "' target='_blank'>GO TO PAYMENT</a></p>";
    } else {
        // استفاده از isset/ternary برای سازگاری با PHP < 7.0
        $status_code = (isset($result['status']) ? $result['status'] : 'N/A');
        $error_message = (isset($result['message']) ? $result['message'] : 'Check your Merchant ID/Firewall');
        
        echo "<h4 style='color:red'>FAILED! Zarinpal Status Code: " . $status_code . "</h4>";
        echo "<p>Message: " . htmlspecialchars($error_message) . "</p>";
    }

} catch (Throwable $e) {
    echo "<h3 style='color:red'>❌ FATAL NETWORK CRASH</h3>";
    echo "<p>The cURL request failed (Host/Firewall/Network Problem).</p>";
    echo "<strong>PHP Error:</strong> " . htmlspecialchars($e->getMessage());
}
?>