<?php
ob_start();
ini_set('display_errors', 1);
error_reporting(E_ALL);

// لیست فایل‌های مورد نیاز
$required_files = [
    __DIR__ . '/config.php',
    __DIR__ . '/src/Database/Connection.php',
    __DIR__ . '/src/Database/OrderQueries.php',
    __DIR__ . '/src/Database/UserQueries.php',
    __DIR__ . '/src/Database/TransactionQueries.php',
    __DIR__ . '/src/Database/SettingQueries.php', // جدید
    __DIR__ . '/src/Services/ZarinpalService.php',
    __DIR__ . '/src/Services/ZibalService.php',   // جدید
    __DIR__ . '/src/Utils/GeneralHelpers.php',
    __DIR__ . '/src/Utils/FormattingHelpers.php',
    __DIR__ . '/src/Database/LogQueries.php',
    __DIR__ . '/src/Utils/EncryptionHelpers.php',
    __DIR__ . '/src/Database/CardQueries.php',
    __DIR__ . '/src/Utils/ValidationHelpers.php',
];

foreach ($required_files as $file) {
    if (!file_exists($file)) {
        ob_end_clean();
        if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - CRITICAL (pay.php): Required file not found: {$file}\n", FILE_APPEND); }
        die("<html lang='fa' dir='rtl'><head><title>خطا</title><meta charset='utf-8'></head><body><p style='color:red; text-align:center;'>خطای سیستمی: فایل ضروری یافت نشد. لطفا با پشتیبانی تماس بگیرید.</p></body></html>");
    }
    require_once $file;
}

function display_payment_page(string $message, string $type = 'info', ?string $redirect_url = null): void {
    if (!headers_sent()) {
         ob_end_clean();
    }
    echo "<!DOCTYPE html><html lang='fa' dir='rtl'><head><title>پرداخت سفارش</title><meta charset='utf-8'><meta name='viewport' content='width=device-width, initial-scale=1.0'><style>body { font-family: sans-serif; padding: 20px; text-align: center; background-color: #f9f9f9; } .container { max-width: 500px; margin: 50px auto; background: #fff; padding: 30px; border-radius: 8px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); } p { margin-bottom: 20px; line-height: 1.6; } .success { color: #155724; background-color: #d4edda; border-color: #c3e6cb; padding: 15px; border-radius: 5px; border: 1px solid transparent; } .error { color: #721c24; background-color: #f8d7da; border-color: #f5c6cb; padding: 15px; border-radius: 5px; border: 1px solid transparent; } .info { color: #004085; background-color: #cce5ff; border-color: #b8daff; padding: 15px; border-radius: 5px; border: 1px solid transparent; } a { color: #007bff; text-decoration: none; font-weight: bold; } a:hover { text-decoration: underline; }</style>";
    
    if ($type === 'info' && $redirect_url) {
        echo '<meta http-equiv="refresh" content="1;url=' . htmlspecialchars($redirect_url) . '">';
    }
    
    echo "</head><body><div class='container'>";
    echo "<p class='{$type}'>" . htmlspecialchars($message) . "</p>";
    
    if ($type === 'info' && $redirect_url) {
        echo "<p>در حال هدایت به صفحه پرداخت...<br>اگر به صورت خودکار هدایت نشدید، <a href='" . htmlspecialchars($redirect_url) . "' id='redirectLink'>اینجا کلیک کنید</a>.</p>";
        echo "<script type='text/javascript'> try { window.location.replace(" . json_encode($redirect_url) . "); } catch(e) { console.error('Redirect failed:', e); document.getElementById('redirectLink').style.fontWeight = 'bold'; } </script>";
    } else {
      echo "<p><a href='javascript:history.back()'>بازگشت</a></p>";
    }
    echo "</div></body></html>";
    exit;
}

// 1. دریافت و اعتبارسنجی شناسه سفارش
$order_id = filter_input(INPUT_GET, 'order_id', FILTER_VALIDATE_INT);
if (!$order_id || $order_id <= 0) {
    display_payment_page('خطا: شماره سفارش نامعتبر است.', 'error');
}

try {
    // 2. دریافت اطلاعات سفارش
    $order = getOrderDetails($order_id);
    if (!$order) {
        display_payment_page("خطا: سفارشی با شماره {$order_id} یافت نشد.", 'error');
    }

    // 3. بررسی وضعیت سفارش
    if (!in_array($order['status'], ['awaiting_online_payment', 'payment_failed', 'awaiting_shipping_fee'])) {
        $status_fa = translate_status_to_persian($order['status']);
        display_payment_page("وضعیت فعلی سفارش ({$status_fa}) اجازه پرداخت آنلاین را نمی‌دهد.", 'info');
    }
    
    // 4. محاسبه مبلغ
    $total_amount_toman = '0.00';
    $payment_description = "پرداخت سفارش شماره {$order_id}";
    
    if ($order['status'] === 'awaiting_shipping_fee') {
        if (!empty($order['payment_ref_id'])) {
            // اگر قبلا کالا پرداخت شده، فقط هزینه پست را بگیر
            $total_amount_toman = $order['shipping_fee'] ?? '0.00';
            $payment_description = "پرداخت هزینه ارسال سفارش شماره {$order_id}";
        } else {
            // اگر کالا پرداخت نشده (مثلا در تلاش اول)، کل مبلغ را بگیر
            $total_amount_toman = $order['total_amount'] ?? '0.00';
             if (bccomp((string)($order['shipping_fee'] ?? '0.00'), '0.00', BC_SCALE) > 0) {
                 $total_amount_toman = bcadd($total_amount_toman, (string)$order['shipping_fee'], BC_SCALE);
             }
        }
    } else if (in_array($order['status'], ['awaiting_online_payment', 'payment_failed'])) {
        $total_amount_toman = $order['total_amount'] ?? '0.00';
        if (bccomp((string)($order['shipping_fee'] ?? '0.00'), '0.00', BC_SCALE) > 0) {
             $total_amount_toman = bcadd($total_amount_toman, (string)$order['shipping_fee'], BC_SCALE);
        }
    }
    
    $amount_rial = (int) bcmul((string)$total_amount_toman, '10', 0);
    
    if ($amount_rial <= 0) {
         display_payment_page('خطا: مبلغ سفارش صفر یا نامعتبر است.', 'error');
    }

    // 5. اطلاعات کاربر و کارت
    $user_id = $order['user_id'];
    $user_phone = $order['phone_number'] ?? '';
    $user_national_code = $order['national_id_code'] ?? null; // برای زیبال

    $card_number_to_restrict = null;
    $card_found_and_decrypted = false;

    // طبق سناریوی جدید، همه کاربران (همکار و مشتری همکار) باید کارتشان مشخص باشد
    if (!empty($order['selected_user_card_id']) && $order['order_type'] !== 'verification') {
        $decrypted_card = getDecryptedUserCardById((int)$order['selected_user_card_id'], $user_id);
        
        if ($decrypted_card && validateCardNumberFormat($decrypted_card)) {
            $card_number_to_restrict = $decrypted_card;
            $card_found_and_decrypted = true;
            // لاگ جهت اطمینان
            // logUserActivity($user_id, 'payment_card_lock_prepared', ['order_id' => $order_id]);
        } else {
            if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - CRITICAL (pay.php): Failed to decrypt selected card (CardID: {$order['selected_user_card_id']}) for order {$order_id}. Payment restricted but card not found.\n", FILE_APPEND); }
            display_payment_page('خطا: اطلاعات کارت انتخاب شده برای پرداخت یافت نشد یا نامعتبر است.', 'error');
        }
    } elseif ($order['order_type'] === 'product' || $order['order_type'] === 'invoice') {
        // اگر سفارش محصول است اما کارتی انتخاب نشده (که نباید پیش بیاید چون اجباری کردیم)
         if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - WARNING (pay.php): Order {$order_id} has no selected card. Security check might fail.\n", FILE_APPEND); }
    }

    // 6. تشخیص درگاه فعال
    $active_gateway = getActiveGateway(); // از SettingQueries.php
    
    // برای اطمینان، اگر تنظیمات برنگشت، پیش‌فرض زرین‌پال باشد
    if (empty($active_gateway)) $active_gateway = 'zarinpal';

    $payment_result = ['success' => false, 'message' => 'Gateway init failed'];
    $provider_name = $active_gateway;

    // 7. درخواست پرداخت بر اساس درگاه
    if ($active_gateway === 'zibal') {
        // --- ZIBAL ---
        $allowedCards = $card_found_and_decrypted ? [$card_number_to_restrict] : null;
        
        $payment_result = requestZibalPayment(
            $amount_rial,
            $payment_description,
            ZIBAL_CALLBACK_URL,
            $user_phone,
            $allowedCards,
            $user_national_code, // ارسال کد ملی برای امنیت بیشتر
            (string)$order_id
        );
        
    } else {
        // --- ZARINPAL (Default) ---
        $metadata = ['mobile' => $user_phone];
        if ($card_found_and_decrypted) {
            $metadata['card_pan'] = $card_number_to_restrict;
        }
        
        $payment_result = requestZarinpalPayment(
            $amount_rial,
            $payment_description,
            ZARINPAL_CALLBACK_URL,
            $metadata
        );
    }

    // 8. بررسی نتیجه درخواست
    if ($payment_result['success']) {
        
        $authority = $payment_result['trackId'] ?? $payment_result['authority']; // زیبال trackId می‌دهد، زرین‌پال authority
        $payment_url = $payment_result['payment_url'];
        
        // به‌روزرسانی اطلاعات سفارش (فقط اتوریتی)
        if ($order['status'] !== 'awaiting_shipping_fee') {
            updateOrderPaymentDetails($order_id, $authority);
        }
        
        // ایجاد رکورد تراکنش
        // تابع createTransaction باید آپدیت شده باشد تا provider را بگیرد، 
        // اما چون تابع شما آرگومان چهارم ندارد، ما فعلا با کوئری دستی آپدیت می‌کنیم یا فرض می‌کنیم تابع تغییر نکرده.
        // بهتر است یک تابع جدید در TransactionQueries بسازید یا همینجا هندل کنیم.
        // فعلاً همان تابع استاندارد را صدا می‌زنیم و سپس provider را آپدیت می‌کنیم.
        
        $transaction_id = createTransaction($order_id, $authority, $amount_rial);
        
        if ($transaction_id > 0) {
            // آپدیت دستی درگاه در تراکنش
            $pdo = pdo();
            $stmt_prov = $pdo->prepare("UPDATE payment_transactions SET provider = ? WHERE id = ?");
            $stmt_prov->execute([$provider_name, $transaction_id]);
        } else {
            if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - CRITICAL (pay.php): Failed to create transaction record for order {$order_id}.\n", FILE_APPEND); }
            display_payment_page('خطایی در سیستم ثبت پرداخت رخ داد.', 'error');
        }
     
        ob_end_clean();

        if (!headers_sent()) {
            header('Location: ' . $payment_url);
            exit;
        } else {
             display_payment_page('در حال هدایت به صفحه پرداخت...', 'info', $payment_url);
        }
        
    } else {
        // خطا در ایجاد درخواست پرداخت
        logUserActivity($user_id, 'payment_request_failed', ['order_id' => $order_id, 'gateway' => $active_gateway, 'error' => $payment_result['message']]);
        $error_message = "خطا در اتصال به درگاه ({$active_gateway}): " . ($payment_result['message'] ?? 'خطای نامشخص');
        display_payment_page($error_message, 'error');
    }

} catch (PDOException $db_e) {
     if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - CRITICAL DB Error (pay.php) for Order ID {$order_id}: " . $db_e->getMessage() . "\n", FILE_APPEND); }
   display_payment_page('خطای پایگاه داده رخ داده است. لطفا با پشتیبانی تماس بگیرید.', 'error');
} catch (Exception $e) {
     if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - General Error (pay.php) for Order ID {$order_id}: " . $e->getMessage() . "\n", FILE_APPEND); }
   display_payment_page('خطای سیستمی رخ داده است: ' . $e->getMessage(), 'error');
}

if (ob_get_level() > 0) {
    ob_end_flush();
}
?>