<?php

error_reporting(E_ALL);
ini_set('display_errors', 1);


require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../src/Database/Connection.php';
require_once __DIR__ . '/../src/Utils/FormattingHelpers.php';
require_once __DIR__ . '/../src/Utils/GeneralHelpers.php';

require_once __DIR__ . '/../src/Database/OrderQueries.php';
require_once __DIR__ . '/../src/Database/LogQueries.php';
require_once __DIR__ . '/../src/Database/UserQueries.php';
require_once __DIR__ . '/../src/Database/TransactionQueries.php';
require_once __DIR__ . '/../src/Services/ZarinpalService.php';
require_once __DIR__ . '/../src/Services/BotApiService.php';

require_once __DIR__ . '/../src/Utils/KeyboardBuilders.php';

function sendMessageToUser(?int $telegram_chat_id, ?int $bale_chat_id, string $message, ?array $reply_markup = null): void {
    
    if (defined('ERROR_LOG_PATH')) {
        $log_entry = date('Y-m-d H:i:s') . " - [Callback Notify] Attempting to send message.\n";
        $log_entry .= "Message: " . mb_substr($message, 0, 100) . "...\n";
    }

    if ($telegram_chat_id) {
        
        if (defined('ERROR_LOG_PATH')) {
            $log_entry .= "Target (Telegram): {$telegram_chat_id}\n";
        }
        
        $response_tg = sendPushMessage('telegram', $telegram_chat_id, $message, $reply_markup);
        
        if (defined('ERROR_LOG_PATH')) {
            $log_entry .= "Response (Telegram/Bridge): " . json_encode($response_tg) . "\n";
        }
    }

    if ($bale_chat_id) {
        
        if (defined('ERROR_LOG_PATH')) {
            $log_entry .= "Target (Bale): {$bale_chat_id}\n";
        }

        $response_bale = sendPushMessage('bale', $bale_chat_id, $message, $reply_markup);
        
        if (defined('ERROR_LOG_PATH')) {
            $log_entry .= "Response (Bale): " . json_encode($response_bale) . "\n";
        }
    }

    if (defined('ERROR_LOG_PATH')) {
        file_put_contents(ERROR_LOG_PATH, $log_entry . "---\n", FILE_APPEND);
    }
}

$authority = $_GET['Authority'] ?? null;
$status = $_GET['Status'] ?? null;

$user_message = "نتیجه پرداخت شما در حال بررسی است...";
$final_order_status = null;
$final_transaction_status = null;
$order_id_for_log = 'N/A';
$user_telegram_chat_id = null;
$user_bale_chat_id = null;
$user_internal_id = null;
$html_message_for_page = $user_message;
$is_verification_payment = false;
$order_type = 'product'; 
try {
    if (empty($authority) || empty($status)) {
        throw new Exception("پارامترهای بازگشتی از درگاه پرداخت ناقص است.");
    }
    

    $transaction = getTransactionByAuthority($authority); 

   
    
    if (!$transaction) {
        throw new Exception("خطا: تراکنش پرداخت مرتبط با این Authority یافت نشد (Authority: {$authority}).");
    }

    $order_id = $transaction['order_id'];
    $order_id_for_log = $order_id;
    $user_internal_id = $transaction['user_id'];
    $user_telegram_chat_id = $transaction['telegram_chat_id'];
    $user_bale_chat_id = $transaction['bale_chat_id'];
    $amount_rial = $transaction['amount_rial'] ?? 0;
    $current_order_status = $transaction['order_status'] ?? 'unknown';
    $current_transaction_status = $transaction['status'] ?? 'unknown';
    $order_type = $transaction['order_type'] ?? 'product'; 
    
    if ($user_internal_id) {
        updateUserField($user_internal_id, 'session_last_activity', date('Y-m-d H:i:s'));
    }

    
    
   
    if ($order_type === 'verification') {
        $is_verification_payment = true;
    }


    if ($current_transaction_status !== 'pending') {
         $current_status_fa = translate_status_to_persian($current_order_status);
        $user_message = "وضعیت پرداخت شما قبلاً به‌روزرسانی شده است. 
وضعیت سفارش: *{$current_status_fa}*";
         if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - Zarinpal Callback: Attempt to process already finalized transaction for order ID {$order_id} with transaction status {$current_transaction_status}.\n", FILE_APPEND); }
         $html_message_for_page = strip_tags(str_replace(['`','*'], '', $user_message));
         
         sendMessageToUser($user_telegram_chat_id, $user_bale_chat_id, $user_message);
         
    }
    elseif ($status === 'OK') {

        $verify_result = verifyZarinpalPayment($amount_rial, $authority);

    
        if ($verify_result['success']) {
            $ref_id = $verify_result['ref_id'];
            $card_pan_masked = $verify_result['card_pan'];

            
            $final_order_status = 'processing';
            $final_transaction_status = 'verified';

    
            updateOrderStatus($order_id, $final_order_status);
            
            if ($current_order_status !== 'awaiting_shipping_fee') {
                updateOrderPaymentDetails($order_id, $authority, $ref_id, $card_pan_masked);
            }
            
            updateTransactionStatus($authority, $final_transaction_status, $ref_id, $card_pan_masked);

            logUserActivity($user_internal_id, 'payment_success', ['order_id' => $order_id, 'ref_id' => $ref_id, 'amount_rial' => $amount_rial]);
         
            if ($is_verification_payment) {
           
     
                $user_data = getUserById($user_internal_id);
                $is_partner_customer = ($user_data && isset($user_data['referred_by_user_id']) && $user_data['referred_by_user_id'] !== null);

                sendMessageToUser($user_telegram_chat_id, $user_bale_chat_id, "✅ پرداخت شما برای احراز هویت با موفقیت انجام و تایید شد.\n\nشماره پیگیری زرین‌پال: `{$ref_id}`");

                if ($is_partner_customer) {
                    
                    updateUserStatus($user_internal_id, 'awaiting_national_id_code');
                    $html_message_for_page = "پرداخت شما موفق بود. لطفا به ربات بازگردید و ادامه مراحل (ورود کد ملی) را انجام دهید.";
                    sendMessageToUser($user_telegram_chat_id, $user_bale_chat_id, "لطفا *کد ملی* خود را (۱۰ رقمی و بدون خط تیره) وارد کنید:", null);
             
                } else {
                    
                    updateUserStatus($user_internal_id, 'awaiting_birth_year');
                    $keyboard_markup = buildBirthYearKeyboard('selectBirth', 0);
                    $html_message_for_page = "پرداخت شما موفق بود. لطفا به ربات بازگردید و ادامه مراحل (انتخاب تاریخ تولد) را انجام دهید.";
    
                    sendMessageToUser($user_telegram_chat_id, $user_bale_chat_id, "لطفا *سال* تولد خود را (۴ رقمی شمسی) از گزینه‌های زیر انتخاب کنید:", $keyboard_markup);
                }

            } else {
                
                if ($current_order_status === 'awaiting_shipping_fee') {
                    $user_message = "✅ هزینه ارسال سفارش `{$order_id}` با موفقیت پرداخت شد.\n\nشماره پیگیری زرین‌پال: `{$ref_id}`\n\nسفارش شما به زودی پردازش خواهد شد.";
                } else {
                    $user_message = "✅ پرداخت شما برای سفارش شماره `{$order_id}` با موفقیت انجام و تایید شد.\n\nشماره پیگیری زرین‌پال: `{$ref_id}`\n\nسفارش شما به زودی پردازش خواهد شد.";
                }
     
                sendMessageToUser($user_telegram_chat_id, $user_bale_chat_id, $user_message);
                $html_message_for_page = strip_tags(str_replace(['`','*'], '', $user_message));
            }
          
            
            $order_type_fa = 'محصول';
            if ($order_type === 'verification') { $order_type_fa = 'احراز هویت'; }
            elseif ($order_type === 'invoice') { $order_type_fa = 'فاکتور آزاد'; }
            
            $admin_message = "✅ پرداخت موفق (نوع: *{$order_type_fa}*) برای فاکتور `{$order_id}` توسط کاربر `{$user_internal_id}` تایید شد.\nRefID: `{$ref_id}`\nکارت: `{$card_pan_masked}`";
            if ($current_order_status === 'awaiting_shipping_fee') {
                $admin_message = "✅ پرداخت موفق (هزینه ارسال) برای فاکتور `{$order_id}` تایید شد.\nRefID: `{$ref_id}`";
            }
            notifyAdmins($admin_message);

        } else {
            $final_order_status = 'payment_failed';
            $final_transaction_status = 'failed';

            
            if ($current_order_status !== 'awaiting_shipping_fee') {
                updateOrderStatus($order_id, $final_order_status);
            }
            if ($current_order_status !== 'awaiting_shipping_fee') {
                updateOrderPaymentDetails($order_id, $authority);
            }
            updateTransactionStatus($authority, $final_transaction_status);

            logUserActivity($user_internal_id, 'payment_verify_failed', ['order_id' => $order_id, 'authority' => $authority, 'zarinpal_code' => $verify_result['code'], 'zarinpal_message' => $verify_result['message']]);
            
            if ($is_verification_payment) {
   
              $user_message = "❌ مشکلی در تایید پرداخت احراز هویت شما پیش آمد.\n\nعلت: " . $verify_result['message'];
   
            } elseif ($current_order_status === 'awaiting_shipping_fee') {
                $user_message = "❌ مشکلی در تایید پرداخت هزینه ارسال شما برای سفارش `{$order_id}` پیش آمد.\n\nعلت: " . $verify_result['message'];
            } else {
                $user_message = "❌ مشکلی در تایید پرداخت شما برای سفارش `{$order_id}` پیش آمد.\n\nعلت: " . $verify_result['message'];
            }
            
            $payment_page_url = PAYMENT_PAGE_URL . '?order_id=' . $order_id;
            $buttons = [[['text' => '💰 تلاش مجدد برای پرداخت', 'url' => $payment_page_url]]];
            sendMessageToUser($user_telegram_chat_id, $user_bale_chat_id, $user_message, ['inline_keyboard' => $buttons]);
           
 
            $html_message_for_page = strip_tags(str_replace(['`','*'], '', $user_message));

            $order_type_fa = 'محصول';
            if ($order_type === 'verification') { $order_type_fa = 'احراز هویت'; }
            elseif ($order_type === 'invoice') { $order_type_fa = 'فاکتور آزاد'; }
            
            $admin_message = "❌ تایید پرداخت (Verify) برای فاکتور `{$order_id}` (نوع: *{$order_type_fa}*, Authority: `{$authority}`) ناموفق بود.\nعلت: " . $verify_result['message'] . " (Code: {$verify_result['code']})";
            notifyAdmins($admin_message);
         }
    } else {
        $final_order_status = 'payment_failed';
        $final_transaction_status = ($status === 'NOK') ? 'canceled' : 'failed';


        
        if ($current_order_status !== 'awaiting_shipping_fee') {
            updateOrderStatus($order_id, $final_order_status);
        }
        if ($current_order_status !== 'awaiting_shipping_fee') {
            updateOrderPaymentDetails($order_id, $authority);
        }
        updateTransactionStatus($authority, $final_transaction_status);

        logUserActivity($user_internal_id, 'payment_canceled_or_failed', ['order_id' => $order_id, 'authority' => $authority, 'status' => $status]);
        
        if ($is_verification_payment) {
 
             $user_message = "❌ پرداخت شما برای احراز هویت ناموفق بود یا توسط شما لغو شد.";
     
        } elseif ($current_order_status === 'awaiting_shipping_fee') {
            $user_message = "❌ پرداخت هزینه ارسال سفارش `{$order_id}` ناموفق بود یا توسط شما لغو شد.";
        } else {
            $user_message = "❌ پرداخت شما برای سفارش `{$order_id}` ناموفق بود یا توسط شما لغو شد. در صورت کسر وجه، مبلغ طی ۷۲ ساعت آینده به حساب شما باز خواهد گشت.";
        }

       
         $payment_page_url = PAYMENT_PAGE_URL . '?order_id=' . $order_id;
        $buttons = [[['text' => '💰 تلاش مجدد برای پرداخت', 'url' => $payment_page_url]]];
         sendMessageToUser($user_telegram_chat_id, $user_bale_chat_id, $user_message, ['inline_keyboard' => $buttons]);


        $html_message_for_page = strip_tags(str_replace(['`','*'], '', $user_message));

        $order_type_fa = 'محصول';
        if ($order_type === 'verification') { $order_type_fa = 'احراز هویت'; }
        elseif ($order_type === 'invoice') { $order_type_fa = 'فاکتور آزاد'; }

        $admin_message = "⚠️ پرداخت برای فاکتور `{$order_id}` (نوع: *{$order_type_fa}*, Authority: `{$authority}`) ناموفق بود یا توسط کاربر لغو شد. (Status: {$status})";
 
       notifyAdmins($admin_message);
    }


} catch (Exception $e) {
    $error_message = $e->getMessage();
    if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - Zarinpal Callback CRITICAL Error: " . $error_message . " | Authority: {$authority}\n", FILE_APPEND); }

    if ($user_internal_id) {
       
      $user_message = "❌ خطای سیستمی در پردازش پرداخت رخ داد. لطفا با پشتیبانی تماس بگیرید. Order ID: {$order_id_for_log}";
    } else {
     
      $user_message = "❌ خطای سیستمی در پردازش پرداخت رخ داد. لطفا با پشتیبانی تماس بگیرید.";
    }

    
$html_message_for_page = strip_tags(str_replace(['`','*'], '', $user_message));

    if ($user_telegram_chat_id || $user_bale_chat_id) {
        sendMessageToUser($user_telegram_chat_id, $user_bale_chat_id, $user_message);
   
    }

    $admin_message = "🔥 خطای سیستمی بحرانی در Zarinpal Callback 🔥\nError: {$error_message}\nAuthority: `{$authority}`\nOrder ID: {$order_id_for_log}";
     notifyAdmins($admin_message); 

    if ($order_id_for_log !== 'N/A' && $final_order_status === null) {
         try {
             
             if (($current_order_status ?? 'unknown') !== 'awaiting_shipping_fee') {
                 updateOrderStatus((int)$order_id_for_log, 'payment_failed');
             }
   
          if ($authority && $final_transaction_status === null) {
                 updateTransactionStatus($authority, 'failed');
             }
         } catch (Exception $ex) {}
    }
}


echo "<html lang='fa' dir='rtl'><head><title>نتیجه پرداخت</title><meta charset='utf-8'><style>body { font-family: sans-serif; padding: 20px; text-align: 
center; } p { margin-bottom: 15px; } .success { color: green; border: 1px solid green; padding: 10px; border-radius: 5px; background-color: #e6ffe6; } .error { color: red; border: 1px solid red; padding: 10px; border-radius: 5px; background-color: #ffe6e6;} .info { color: blue; border: 1px solid blue; padding: 10px; border-radius: 5px; background-color: #e6e6ff;}</style></head><body>";
if (strpos($html_message_for_page, 'موفق بود') !== false) {
    echo "<p class='success'>" . htmlspecialchars($html_message_for_page) . "</p>";
} elseif (strpos($html_message_for_page, 'خطا') !== false || strpos($html_message_for_page, 'ناموفق') !== false) {
    echo "<p class='error'>" . htmlspecialchars($html_message_for_page) . "</p>";
} else {
   
 echo "<p class='info'>" . htmlspecialchars($html_message_for_page) . "</p>";
}
echo "<p>می‌توانید به ربات بازگردید.</p></body></html>";

?>