<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

if (!function_exists('handleVerificationStep')) {
    function handleVerificationStep($status, ?array $message, int $chat_id, int $user_id, string $platform, array $session_data) {
        global $user;
        
         if (!$user) { $user = getUserById($user_id); }
        if (!$user) { return; } 

        switch ($status) {
           case 'awaiting_phone':
                $first_name = $user['first_name'] ?? 'کاربر';
         
                sendMessage(
                     $chat_id,
                   "سلام {$first_name} عزیز!\nبرای استفاده از ربات، لطفا شماره موبایل خود را از طریق دکمه زیر به اشتراک بگذارید.",
                     ['keyboard' => [[['text' => '📱 اشتراک گذاری شماره موبایل', 'request_contact' => true]]], 'resize_keyboard' => true, 'one_time_keyboard' => true],
                     $platform
                );
             break;
             case 'awaiting_otp':
                 $buttons = [[['text' => '🔄 ارسال مجدد کد', 'callback_data' => buildCallbackData('resendOtp')]]];
                 sendMessage($chat_id, "کد تایید ۵ رقمی که به شماره شما ارسال شد را وارد کنید.", ['inline_keyboard' => $buttons], $platform);
                 break;
            case 'awaiting_full_name':
                 sendMessage($chat_id, "لطفا نام و نام خانوادگی خود را به صورت کامل (فارسی) وارد کنید:", ['remove_keyboard' => true], $platform); 
                 break;
             case 'awaiting_national_id_photo':
                 
                 $message_text = "*مرحله بعد:* لطفاً یک عکس واضح از *چهره خودتان در کنار کارت ملی* ارسال کنید.\n(مطمئن شوید هر دو واضح هستند)";
                 if (empty($user['selfie_data'])) {
                     $message_text = "✅ نام شما ثبت شد.\n\n" . $message_text;
                 }
                 
                 sendMessage($chat_id, $message_text, null, $platform);
                 break;

             case 'awaiting_national_id_code':
                 sendMessage($chat_id, "لطفا کد ملی خود را (۱۰ رقمی و بدون خط تیره) وارد کنید.", null, $platform);
             break;
             case 'awaiting_verification_payment':
          
                 sendVerificationPaymentRequest($chat_id, $user_id, $platform, $user['phone_number'] ?? '');
                 break;
             case 'awaiting_birth_year':

                 $keyboard_markup = buildBirthYearKeyboard('selectBirth', 0); 
                 sendMessage($chat_id, "لطفا *سال* تولد خود را (۴ رقمی شمسی) از گزینه‌های زیر انتخاب کنید:", $keyboard_markup, $platform);
                 break;
            case 'awaiting_birth_month':
                 $year = $session_data['birth_date_year'] ?? 0;
                 if ($year > 1300) {
        
                     $keyboard_markup = buildBirthMonthKeyboard('selectBirth', $year);
                     $keyboard_markup['inline_keyboard'][] = [['text' => '🔙 بازگشت (انتخاب سال)', 'callback_data' => buildCallbackData('backToBirthYear')]];
            
                 sendMessage($chat_id, "لطفا *ماه* تولد خود را انتخاب کنید:", $keyboard_markup, $platform);
                 } else {
                     handleVerificationStep('awaiting_birth_year', $message, $chat_id, $user_id, $platform, $session_data);
                 }
                 break;
             case 'awaiting_birth_day':
                 
                 $year = $session_data['birth_date_year'] ?? 0;
                 $month = $session_data['birth_date_month'] ?? 0;
         
                  
                 if ($year > 1300 && $month > 0) {
                     $keyboard_markup = buildBirthDayKeyboard('selectBirth', $year, $month);
                    
                     $keyboard_markup['inline_keyboard'][] = [['text' => '🔙 بازگشت (انتخاب ماه)', 'callback_data' => buildCallbackData('backToBirthMonth', ['y' => $year])]];
            
                     sendMessage($chat_id, "لطفا *روز* تولد خود را انتخاب کنید:", $keyboard_markup, $platform);
                 } else {
                      handleVerificationStep('awaiting_birth_month', $message, $chat_id, $user_id, $platform, $session_data);
                 }
                 break;
           case 'awaiting_selfie':
                $caption = "عالی! حالا لطفاً فایل قرارداد زیر را دانلود و چاپ کنید. پس از امضا و اثر انگشت، یک عکس واضح از *برگه تکمیل شده* ارسال نمایید.";
                if (defined('CONTRACT_PDF_PATH') && file_exists(CONTRACT_PDF_PATH)) {
             
                sendDocument($chat_id, CONTRACT_PDF_PATH, $caption, $platform);
                } else {
                       sendMessage($chat_id, $caption . "\n\n(خطا: فایل قرارداد یافت نشد. لطفا با پشتیبانی تماس بگیرید.)", null, $platform);
                }
                 break;
            case 'awaiting_admin_selfie_approval':
                 sendMessage($chat_id, "پرونده شما در حال بررسی توسط مدیر است. لطفا تا زمان اعلام نتیجه صبور باشید.", null, $platform);
                 break;
             case 'awaiting_physical_code':
                  sendMessage($chat_id, "لطفا کد فعال‌سازی فیزیکی که دریافت کرده‌اید را وارد کنید.", null, $platform);
                  break;
             case 'identity_rejected':

                handleRejectionMessage($chat_id, $user['admin_rejection_reason'] ?? '', $platform);
                  break;
            default:
                 sendMessage($chat_id, "وضعیت نامشخص. با /start مجددا تلاش کنید.", null, $platform);
                 break;
        }
    }
}

global $update, $user, $user_id, $platform;

$verification_chat_id = $update['message']['chat']['id'] ?? $update['callback_query']['message']['chat']['id'] ?? 0;
if ($verification_chat_id === 0) {

    
if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - Error: Could not determine chat ID in VerificationHandler.\nUpdate: " . json_encode($update) . "\n", FILE_APPEND); }
    http_response_code(200);
    
    if (!defined('IS_BRIDGE_CALL') || IS_BRIDGE_CALL !== true) { exit(); } else { return; }
    
}

$message = $update['message'] ?? null;
       
$callback_query = $update['callback_query'] ?? null;
$message_text_raw = $message['text'] ?? null;
$message_text = $message_text_raw ? trim(convertPersianToEnglishDigits($message_text_raw)) : null;
$callback_data_str = $callback_query['data'] ?? null;
    
$current_status = $user['status'] ?? 'unknown';
$session_data = $user['session'] ? json_decode($user['session'], true) : [];
if (!is_array($session_data)) { $session_data = []; }


    if ($message_text_raw !== null) {
        logUserActivity($user_id, 'verification_message', ['status' => $current_status, 'text' => $message_text_raw]);
} elseif ($callback_data_str !== null) {
     logUserActivity($user_id, 'verification_callback', ['status' => $current_status, 'data' => $callback_data_str]);
}


if ($message_text_raw === '/start') {
    
    global $user;
    $user = getUserById($user_id); 
    if (!$user) { 
        if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - CRITICAL Error: User {$user_id} not found in VerificationHandler /start block.\n", FILE_APPEND); }
        if (!defined('IS_BRIDGE_CALL') || IS_BRIDGE_CALL !== true) { exit(); } else { return; }
    } 
    
    $current_status = $user['status'] ?? 'unknown'; 
    $session_data = $user['session'] ? json_decode($user['session'], true) : []; 
    if (!is_array($session_data)) { $session_data = []; }

    if ($current_status === 'identity_rejected') {
        resetUser($user_id);
        handleVerificationStep('awaiting_phone', null, $verification_chat_id, $user_id, $platform, $session_data);
    } else {
        

        handleVerificationStep($current_status, null, $verification_chat_id, $user_id, $platform, $session_data);
    }
    
    
    if (!defined('IS_BRIDGE_CALL') || IS_BRIDGE_CALL !== true) { exit(); } else { return; }
    
}

if ($callback_query !== null && $callback_data_str !== null) {
    
$callback_query_id = $callback_query['id'] ?? null;
     $message_id = $callback_query['message']['message_id'] ?? null;
    $callback_params = parseCallbackData($callback_data_str);
    
    $action = $callback_params['action'] ?? 'noop';

    if ($callback_query_id) {
        apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id], $platform);
    }

  if (strpos($action, 'selectBirth') === 0 || $action === 'selectBirthYearPage' || $action === 'backToBirthYear' || $action === 'backToBirthMonth') {
        handleBirthdateCallback($action, $callback_params, $current_status, $verification_chat_id, $message_id, $user_id, $platform, $session_data);
    } elseif ($action === 'resendOtp' && $current_status === 'awaiting_otp') {
        
        $user_data = getUserById($user_id); 
        
handleResendOtp($verification_chat_id, $user_id, $platform, $user_data['phone_number'] ?? null, $user_data['otp_timestamp'] ?? 0, $callback_query_id);
        
    } elseif ($action === 'checkVerificationPayment' && $current_status === 'awaiting_verification_payment') {
        checkVerificationPaymentStatus($verification_chat_id, $user_id, $platform, (int)($callback_params['oid'] ?? 0), $callback_query_id);
    } else {
        sendMessage($verification_chat_id, "لطفا مراحل احراز هویت را دنبال کنید.", null, $platform);
    }
    
    if (!defined('IS_BRIDGE_CALL') || IS_BRIDGE_CALL !== true) { exit(); } else { return; }
    
}
elseif ($message !== null) {
    
    
    global $user;
    $user = getUserById($user_id);
    if (!$user) { 
       if (!defined('IS_BRIDGE_CALL') || IS_BRIDGE_CALL !== true) { exit(); } else { return; }
    }
    $current_status = $user['status'] ?? 'unknown'; 
    
    
    switch ($current_status) {
        case 'awaiting_phone':
            handlePhoneInput($message, $verification_chat_id, $user_id, $platform);
            break;
        case 'awaiting_otp':
            
            handleOtpInput($message_text, $verification_chat_id, $user_id, $platform, $user['otp_code'] ?? null, $user['otp_timestamp'] ?? 0);
            
             break;
       case 'awaiting_full_name':
            handleFullNameInput($message_text, $verification_chat_id, $user_id, $platform);
            break;
        case 'awaiting_national_id_photo':
           
 handleNationalIdPhotoInput($message, $verification_chat_id, $user_id, $platform);
              break;
        case 'awaiting_national_id_code':
            handleNationalIdCodeInput($message_text, $verification_chat_id, $user_id, $platform, $user['phone_number'] ?? '');
            break;
        case 'awaiting_verification_payment':
       
     sendVerificationPaymentRequest($verification_chat_id, $user_id, $platform, $user['phone_number'] ?? '');
           break;
        case 'awaiting_birth_year':
        case 'awaiting_birth_month':
        case 'awaiting_birth_day':
            sendMessage($verification_chat_id, "لطفا از دکمه‌های ارسال شده برای انتخاب تاریخ تولد استفاده کنید.", null, $platform);
            
            break;
        case 'awaiting_selfie':
            handleSelfieInput($message, $verification_chat_id, $user_id, $platform, $user);
            break;
        case 'awaiting_admin_selfie_approval':
            sendMessage($verification_chat_id, "پرونده شما در حال بررسی توسط مدیر است. لطفا تا زمان اعلام نتیجه صبور باشید.", null, $platform);
            
break;
        case 'awaiting_physical_code':
             sendMessage($verification_chat_id, "این مرحله در حال حاضر فعال نیست.", null, $platform);
             break;
        case 'identity_rejected':

             handleRejectionMessage($verification_chat_id, $user['admin_rejection_reason'] ?? '', $platform);
 
            break;
        default:
            if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - Error: Reached VerificationHandler with unexpected status '{$current_status}' for user {$user_id}.\n", FILE_APPEND); }
            sendMessage($verification_chat_id, "خطای داخلی رخ داده است. لطفا با /start مجددا تلاش کنید.", null, $platform);
            resetUser($user_id);
     
       break;
    }
    
    if (!defined('IS_BRIDGE_CALL') || IS_BRIDGE_CALL !== true) { exit(); } else { return; }
    
    
    }
?>