<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

function showValueList(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
    $attribute_id = (int)($params['attr_id'] ?? 0);
    $offset = (int)($params['offset'] ?? 0);
    $limit = 10;
    $can_edit = ($message_id !== null);

    if ($attribute_id <= 0) {
        if ($can_edit) editMessage($chat_id, $message_id, "خطا: ویژگی نامعتبر است.", null);
        showAttributeList([], $chat_id, null, $user_id, $platform, $session_data);
        return;
    }
    
    $stmt_attr = pdo()->prepare("SELECT name FROM attributes WHERE id = ?");
    $stmt_attr->execute([$attribute_id]);
    $attr_name = $stmt_attr->fetchColumn();

    if (!$attr_name) {
        if ($can_edit) editMessage($chat_id, $message_id, "خطا: ویژگی یافت نشد.", null);
        showAttributeList([], $chat_id, null, $user_id, $platform, $session_data);
        return;
    }
    
    $values = getAttributeValues($attribute_id);
    
    $text = "⚙️ *مدیریت مقادیر برای: {$attr_name}*\n\n";
    $text .= "مقادیر موجود:";
    
    $buttons = [];
    if (empty($values)) {
        $text .= "\n(هیچ مقداری برای این ویژگی تعریف نشده است)";
    } else {
        foreach ($values as $val) {
            $buttons[] = [
                ['text' => $val['value'], 'callback_data' => 'noop'],
                ['text' => '❌', 'callback_data' => buildCallbackData('deleteAttrValueConfirm', ['val_id' => $val['id'], 'attr_id' => $attribute_id])]
            ];
        }
    }
    
    $buttons[] = [['text' => '➕ افزودن مقدار جدید', 'callback_data' => buildCallbackData('addAttrValueStart', ['attr_id' => $attribute_id])]];
    $buttons[] = [['text' => '🔙 بازگشت به لیست ویژگی‌ها', 'callback_data' => buildCallbackData('manageAttributes', ['offset' => 0])]];
    
    $reply_markup = ['inline_keyboard' => $buttons];
    
    if ($can_edit) {
        editMessage($chat_id, $message_id, $text, $reply_markup);
    } else {
        sendMessage($chat_id, $text, $reply_markup, $platform);
    }
}

function askForNewValueName(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
    $attribute_id = (int)($params['attr_id'] ?? 0);
    if ($attribute_id <= 0) {
        if ($message_id) editMessage($chat_id, $message_id, "خطا: ویژگی نامعتبر است.", null);
        showAttributeList([], $chat_id, null, $user_id, $platform, $session_data);
        return;
    }

    $stmt_attr = pdo()->prepare("SELECT name FROM attributes WHERE id = ?");
    $stmt_attr->execute([$attribute_id]);
    $attr_name = $stmt_attr->fetchColumn();
    if (!$attr_name) {
        if ($message_id) editMessage($chat_id, $message_id, "خطا: ویژگی یافت نشد.", null);
        showAttributeList([], $chat_id, null, $user_id, $platform, $session_data);
        return;
    }

    $session_data['state'] = 'awaiting_new_value_name';
    $session_data['current_attribute_id'] = $attribute_id;
    updateUserField($user_id, 'session', json_encode($session_data));
    
    $text = "لطفا نام مقدار جدید را برای ویژگی '{$attr_name}' وارد کنید (مثال: قرمز)";
    
    if ($message_id) {
        apiRequest('deleteMessage', ['chat_id' => $chat_id, 'message_id' => $message_id], $platform);
    }
    
    sendMessage(
        $chat_id,
        $text,
        ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true],
        $platform
    );
}

function handleNewValueName(array $message, int $chat_id, int $user_id, string $platform, array $session_data): void {
    $name = trim($message['text'] ?? '');
    $attribute_id = (int)($session_data['current_attribute_id'] ?? 0);

    if ($attribute_id <= 0) {
        sendMessage($chat_id, "خطا: ویژگی نامشخص است. عملیات لغو شد.", ['remove_keyboard' => true], $platform);
        updateUserField($user_id, 'session', json_encode(['state' => 'idle']));
        showAdminMainMenu($chat_id, $user_id, $platform);
        return;
    }
    
    if (empty($name)) {
        sendMessage($chat_id, "نام مقدار نمی‌تواند خالی باشد. لطفا مجددا وارد کنید:", null, $platform);
        return;
    }
    
    $new_id = createAttributeValue($attribute_id, $name);
    
    if ($new_id > 0) {
        sendMessage($chat_id, "✅ مقدار '{$name}' با موفقیت ایجاد شد.", ['remove_keyboard' => true], $platform);
        updateUserField($user_id, 'session', json_encode(['state' => 'idle']));
        showValueList(['attr_id' => $attribute_id, 'offset' => 0], $chat_id, null, $user_id, $platform, ['state' => 'idle']);
    } else {
        sendMessage($chat_id, "❌ خطایی در ایجاد مقدار رخ داد (ممکن است تکراری باشد). لطفا مجددا تلاش کنید.", ['remove_keyboard' => true], $platform);
        updateUserField($user_id, 'session', json_encode(['state' => 'idle']));
        showAttributeList([], $chat_id, null, $user_id, $platform, ['state' => 'idle']);
    }
}

function confirmDeleteAttributeValue(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
    $value_id = (int)($params['val_id'] ?? 0);
    $attribute_id = (int)($params['attr_id'] ?? 0);
    $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null;

    if ($value_id <= 0 || $attribute_id <= 0) {
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: ID نامعتبر.', 'show_alert' => true], $platform);
        return;
    }
    
    $stmt = pdo()->prepare("SELECT value FROM attribute_values WHERE id = ? AND attribute_id = ?");
    $stmt->execute([$value_id, $attribute_id]);
    $val_name = $stmt->fetchColumn();

    if (!$val_name) {
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: مقدار یافت نشد.', 'show_alert' => true], $platform);
        showValueList(['attr_id' => $attribute_id, 'offset' => 0], $chat_id, $message_id, $user_id, $platform, $session_data);
        return;
    }

    $text = "⚠️ آیا از حذف مقدار '{$val_name}' مطمئن هستید؟\n\n";
    $text .= "توجه: با حذف این مقدار، تمام اتصالات آن به محصولات و ترکیب‌ها نیز حذف خواهد شد. این عمل قابل بازگشت نیست.";

    $buttons = [
        [['text' => '❌ بله، حذف کن', 'callback_data' => buildCallbackData('deleteAttrValueExecute', ['val_id' => $value_id, 'attr_id' => $attribute_id])]],
        [['text' => '🔙 انصراف', 'callback_data' => buildCallbackData('manageAttrValues', ['attr_id' => $attribute_id, 'offset' => 0])]]
    ];
    
    editMessage($chat_id, $message_id, $text, ['inline_keyboard' => $buttons]);
}

function handleExecuteDeleteAttributeValue(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
    $value_id = (int)($params['val_id'] ?? 0);
    $attribute_id = (int)($params['attr_id'] ?? 0);
    $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null;

    if ($value_id <= 0 || $attribute_id <= 0) {
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: ID نامعتبر.', 'show_alert' => true], $platform);
        return;
    }

    try {
        if (deleteAttributeValue($value_id)) {
            if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'مقدار با موفقیت حذف شد.'], $platform);
        } else {
            if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: مقدار یافت نشد یا حذف نشد.', 'show_alert' => true], $platform);
        }
    } catch (PDOException $e) {
        if (defined('ERROR_LOG_PATH')) file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - DB Error deleting attribute value {$value_id}: " . $e->getMessage() . "\n", FILE_APPEND);
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطای دیتابیس هنگام حذف.', 'show_alert' => true], $platform);
    }
    
    showValueList(['attr_id' => $attribute_id, 'offset' => 0], $chat_id, $message_id, $user_id, $platform, $session_data);
}

?>