<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

function askForBroadcastMessage(int $chat_id, int $user_id, string $platform, array $session_data): void {
    $session_data['state'] = 'awaiting_broadcast_message';
    updateUserField($user_id, 'session', json_encode($session_data));
    
    sendMessage(
        $chat_id,
        "لطفا پیام همگانی خود را ارسال کنید (این پیام برای *همه* کاربران فعال ربات ارسال خواهد شد):",
        ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true],
        $platform
    );
}

function handleBroadcastMessageInput(array $message, int $chat_id, int $user_id, string $platform, array $session_data): void {
    $message_text = trim($message['text'] ?? '');
    
    if (empty($message_text)) {
        sendMessage($chat_id, "پیام نمی‌تواند خالی باشد. لطفا متن پیام را ارسال کنید یا انصراف دهید.", null, $platform);
        return;
    }

    $session_data['state'] = 'awaiting_broadcast_confirmation';
    $session_data['broadcast_message_text'] = $message_text;
    updateUserField($user_id, 'session', json_encode($session_data));

    $buttons = [
        [['text' => '✅ بله، مطمئنم و می‌خواهم ارسال شود', 'callback_data' => buildCallbackData('confirmBroadcast')]],
        [['text' => '❌ انصراف', 'callback_data' => buildCallbackData('cancelBroadcast')]]
    ];
    $reply_markup = ['inline_keyboard' => $buttons];

    sendMessage($chat_id, "⚠️ *اخطار جدی*\n\nشما در حال ارسال پیام زیر به *تمام* کاربران هستید:\n\n" . $message_text . "\n\nآیا از ارسال این پیام مطمئن هستید؟", $reply_markup, $platform);
}

function handleConfirmBroadcast(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
    $message_text = $session_data['broadcast_message_text'] ?? null;
    $can_edit = ($message_id !== null);

    if (empty($message_text)) {
        if ($can_edit) {
            editMessage($chat_id, $message_id, "❌ خطا: متن پیام یافت نشد. عملیات لغو شد.", null);
        } else {
            sendMessage($chat_id, "❌ خطا: متن پیام یافت نشد. عملیات لغو شد.", null, $platform);
        }
        updateUserField($user_id, 'session', json_encode(['state' => 'idle']));
        showAdminMainMenu($chat_id, $user_id, $platform);
        return;
    }

    $broadcast_id = createBroadcast($message_text);
    
    if ($broadcast_id > 0) {
        $total_users = addBroadcastJobs($broadcast_id);
        
        $msg = "✅ پیام شما در صف ارسال برای {$total_users} کاربر قرار گرفت.\n\n(توجه: ارسال پیام‌ها توسط Cron Job در پس‌زمینه انجام می‌شود و ممکن است دقایقی طول بکشد.)";
        if ($can_edit) {
            editMessage($chat_id, $message_id, $msg, null);
        } else {
            sendMessage($chat_id, $msg, null, $platform);
        }
    } else {
        $msg = "❌ خطایی در ایجاد صف پیام‌رسانی در دیتابیس رخ داد.";
        if ($can_edit) {
            editMessage($chat_id, $message_id, $msg, null);
        } else {
            sendMessage($chat_id, $msg, null, $platform);
        }
    }

    updateUserField($user_id, 'session', json_encode(['state' => 'idle']));
    showAdminMainMenu($chat_id, $user_id, $platform);
}

function handleCancelBroadcast(int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
    $can_edit = ($message_id !== null);
    if ($can_edit) {
        editMessage($chat_id, $message_id, "عملیات پیام‌رسانی لغو شد.", null);
    } else {
        sendMessage($chat_id, "عملیات پیام‌رسانی لغو شد.", null, $platform);
    }
    
    updateUserField($user_id, 'session', json_encode(['state' => 'idle']));
    showAdminMainMenu($chat_id, $user_id, $platform);
}

?>