<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) { die('No direct script access allowed'); }

function askForDiscountCodeName(int $chat_id, int $user_id, string $platform, array $session_data): void {
     $session_data = ['state' => 'awaiting_discount_code_name', 'discount_data' => []];
     updateUserField($user_id, 'session', json_encode($session_data));
     sendMessage($chat_id, "لطفا کد تخفیف جدید را وارد کنید (فقط حروف بزرگ انگلیسی و اعداد):", ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true], $platform);
}

function handleCodeNameInput(array $message, int $chat_id, int $user_id, string $platform, array $session_data): void {
    $message_text = trim($message['text'] ?? '');

    if (empty($message_text)) {
        sendMessage($chat_id, "کد تخفیف نمی‌تواند خالی باشد.", null, $platform);
        sendMessage($chat_id, "👇", ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true, 'one_time_keyboard' => true], $platform);
        return;
    }

    $code = strtoupper(convertPersianToEnglishDigits($message_text));

    if (!validateDiscountCodeFormat($code)) {
         sendMessage($chat_id, "❌ فرمت کد تخفیف نامعتبر است. لطفا از حروف لاتین بزرگ و اعداد استفاده کنید (بدون فاصله و کاراکترهای خاص).", null, $platform);
         sendMessage($chat_id, "👇", ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true, 'one_time_keyboard' => true], $platform);
         return;
    }

    if (discountCodeExists($code)) {
         sendMessage($chat_id, "❌ این کد تخفیف قبلا استفاده شده است. لطفا کد دیگری انتخاب کنید.", null, $platform);
         sendMessage($chat_id, "👇", ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true, 'one_time_keyboard' => true], $platform);
         return;
    }

    $session_data['discount_data']['code'] = $code;
    $session_data['state'] = 'awaiting_discount_type';
    updateUserField($user_id, 'session', json_encode($session_data));
    $buttons = [[['text' => 'درصدی 💶'], ['text' => 'مبلغ ثابت 💰']]];
    sendMessage($chat_id, "کد تخفیف `{$code}` ثبت شد. اکنون نوع تخفیف را انتخاب کنید:", ['keyboard' => $buttons, 'resize_keyboard' => true, 'one_time_keyboard' => true], $platform);
}

function handleDiscountTypeInput(array $message, int $chat_id, int $user_id, string $platform, array $session_data): void {
    $message_text = $message['text'] ?? '';
    $type = null;
    if ($message_text === 'درصدی 💶') { $type = 'percentage'; }
    elseif ($message_text === 'مبلغ ثابت 💰') { $type = 'fixed_amount'; }

    if ($type) {
        $session_data['discount_data']['type'] = $type;
        $session_data['state'] = 'awaiting_discount_value';
        updateUserField($user_id, 'session', json_encode($session_data));
        $prompt = ($type === 'percentage') ?
                  'مقدار تخفیف را به درصد وارد کنید (مثلا: 20):' :
                  'مبلغ تخفیف را به تومان وارد کنید (مثلا: 50000):';
        sendMessage($chat_id, $prompt, ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true], $platform);
    } else {
        sendMessage($chat_id, "لطفا نوع تخفیف را با استفاده از دکمه‌ها انتخاب کنید.", null, $platform);
         $buttons = [[['text' => 'درصدی 💶'], ['text' => 'مبلغ ثابت 💰']]];
         sendMessage($chat_id, "👇", ['keyboard' => $buttons, 'resize_keyboard' => true, 'one_time_keyboard' => true], $platform);
    }
}

function handleDiscountValueInput(array $message, int $chat_id, int $user_id, string $platform, array $session_data): void {
    $message_text = trim($message['text'] ?? '');
    $value = convertPersianToEnglishDigits($message_text);

    if (is_numeric($value) && $value > 0) {
        $type = $session_data['discount_data']['type'] ?? null;
        if ($type === 'percentage' && $value > 100) {
            sendMessage($chat_id, "درصد تخفیف نمی‌تواند بیشتر از 100 باشد.", null, $platform);
             sendMessage($chat_id, "👇", ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true], $platform);
            return;
        }
        $session_data['discount_data']['value'] = $value;
        $session_data['state'] = 'awaiting_discount_max_uses';
        updateUserField($user_id, 'session', json_encode($session_data));
        sendMessage($chat_id, "مقدار تخفیف ثبت شد. لطفا حداکثر تعداد استفاده (عدد مثبت) یا کلمه `null` برای نامحدود را وارد کنید:", ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true], $platform);
    } else {
        sendMessage($chat_id, "لطفا یک مقدار عددی مثبت وارد کنید.", null, $platform);
         sendMessage($chat_id, "👇", ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true], $platform);
    }
}

function handleMaxUsesInput(array $message, int $chat_id, int $user_id, string $platform, array $session_data): void {
    $message_text = trim($message['text'] ?? '');
    $max_uses_input = convertPersianToEnglishDigits($message_text);
    $max_uses = null;
    $valid_input = false;

    if (strtolower($max_uses_input) === 'null') {
         $max_uses = null;
         $valid_input = true;
    } elseif (is_numeric($max_uses_input) && (int)$max_uses_input > 0 && strpos($max_uses_input, '.') === false) {
        $max_uses = (int)$max_uses_input;
        $valid_input = true;
    }

    if ($valid_input) {
        $session_data['discount_data']['max_uses'] = $max_uses;
        
        
        $d = $session_data['discount_data'] ?? null;
        if ($d && isset($d['code'], $d['type'], $d['value'])) {
            $expires_at = null;
            $max_uses = $d['max_uses'] ?? null;

            if(createDiscountCode($d['code'], $d['type'], $d['value'], $max_uses, $expires_at)) {
                $msg = "✅ کد تخفیف `{$d['code']}` (بدون تاریخ انقضا) با موفقیت ایجاد شد.";
                sendMessage($chat_id, $msg, ['remove_keyboard' => true], $platform);
            } else {
                $msg = "❌ خطایی در ایجاد کد تخفیف رخ داد. ممکن است این کد تکراری باشد.";
                sendMessage($chat_id, $msg, ['remove_keyboard' => true], $platform);
            }
            $new_session_data = ['state' => 'idle'];
            updateUserField($user_id, 'session', json_encode($new_session_data));
            showAdminMainMenu($chat_id, $user_id, $platform);
        } else {
             $msg = "❌ خطایی رخ داد: اطلاعات کد تخفیف یافت نشد.";
             sendMessage($chat_id, $msg, ['remove_keyboard' => true], $platform);
             $new_session_data = ['state' => 'idle'];
             updateUserField($user_id, 'session', json_encode($new_session_data));
             showAdminMainMenu($chat_id, $user_id, $platform);
        }
    } else {
        sendMessage($chat_id, "لطفا یک عدد صحیح مثبت یا کلمه `null` وارد کنید.", null, $platform);
         sendMessage($chat_id, "👇", ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true], $platform);
    }
}

function handleAddDiscountCallback(string $action, array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
     $can_edit = ($message_id !== null);
     $year = (int)($params['y'] ?? ($session_data['discount_data']['expires_at_year'] ?? 0));
     $month = (int)($params['m'] ?? ($session_data['discount_data']['expires_at_month'] ?? 0));
     $day = (int)($params['d'] ?? 0);
     $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null;

     if ($action === 'discountSetYear') {
         if ($year > 0) {
             $session_data['discount_data']['expires_at_year'] = $year;
             updateUserField($user_id, 'session', json_encode($session_data));
             $buttons = buildBirthMonthKeyboard('discountSet', $year);
             $buttons[] = [['text' => '🔙 بازگشت (انتخاب سال)', 'callback_data' => buildCallbackData('awaiting_discount_expires_at')]]; 
             if ($can_edit) { editMessage($chat_id, $message_id, "سال `{$year}` انتخاب شد. لطفا ماه را انتخاب کنید:", ['inline_keyboard' => $buttons]); }
         }
     } elseif ($action === 'discountSetMonth') {
         if ($year > 0 && $month >= 1 && $month <= 12) {
             $session_data['discount_data']['expires_at_month'] = $month;
             updateUserField($user_id, 'session', json_encode($session_data));
             $buttons = buildBirthDayKeyboard('discountSet', $year, $month);
             $buttons[] = [['text' => '🔙 بازگشت (انتخاب ماه)', 'callback_data' => buildCallbackData('discountSetYear', ['y' => $year])]];
             if ($can_edit) { editMessage($chat_id, $message_id, "ماه `{$month}` انتخاب شد. لطفا روز را انتخاب کنید:", ['inline_keyboard' => $buttons]); }
         }
     } elseif ($action === 'discountSetDay') {
         $days_in_month = 31;
         if ($month > 6 && $month < 12) $days_in_month = 30;
         elseif ($month == 12) {
             $is_leap = in_array($year % 33, [1, 5, 9, 13, 17, 22, 26, 30]);
             $days_in_month = $is_leap ? 30 : 29;
         }

         if ($year > 0 && $month > 0 && $day > 0 && $day <= $days_in_month) {
             $date = sprintf('%04d-%02d-%02d', $year, $month, $day);
             $session_data['discount_data']['expires_at'] = $date;
             updateUserField($user_id, 'session', json_encode($session_data));
             $buttons = [
                 [['text' => '✅ تایید تاریخ', 'callback_data' => buildCallbackData('discountConfirmDate')]],
                 [['text' => '✏️ ویرایش تاریخ', 'callback_data' => buildCallbackData('discountSetMonth', ['y' => $year, 'm' => $month])]]
             ];
             if ($can_edit) { editMessage($chat_id, $message_id, "تاریخ انقضا: `{$date}`\nآیا تاریخ صحیح است؟", ['inline_keyboard' => $buttons]); }
         } else {
              if ($callback_query_id) { apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'روز انتخاب شده نامعتبر است.', 'show_alert' => true], $platform); }
         }
     } elseif ($action === 'discountConfirmDate') {
         $d = $session_data['discount_data'] ?? null;
         if ($d && isset($d['code'], $d['type'], $d['value'])) {
             $expires_at = $d['expires_at'] ?? null;
             if($expires_at) { $expires_at .= ' 23:59:59'; }
             $max_uses = $d['max_uses'] ?? null;

             if(createDiscountCode($d['code'], $d['type'], $d['value'], $max_uses, $expires_at)) {
                 $expiry_text = $expires_at ? "با تاریخ انقضا `{$d['expires_at']}`" : "بدون تاریخ انقضا";
                 $msg = "✅ کد تخفیف `{$d['code']}` {$expiry_text} با موفقیت ایجاد شد.";
                 if ($can_edit) { editMessage($chat_id, $message_id, $msg, null); }
                 else { sendMessage($chat_id, $msg, null, $platform); }
             } else {
                 $msg = "❌ خطایی در ایجاد کد تخفیف رخ داد. ممکن است این کد تکراری باشد.";
                  if ($can_edit) { editMessage($chat_id, $message_id, $msg, null); }
                  else { sendMessage($chat_id, $msg, null, $platform); }
             }
             $new_session_data = ['state' => 'idle'];
             updateUserField($user_id, 'session', json_encode($new_session_data));
             showAdminMainMenu($chat_id, $user_id, $platform);

         } else {
              $msg = "❌ خطایی رخ داد: اطلاعات کد تخفیف یافت نشد.";
              if ($can_edit) { editMessage($chat_id, $message_id, $msg, null); }
              else { sendMessage($chat_id, $msg, null, $platform); }
              $new_session_data = ['state' => 'idle'];
              updateUserField($user_id, 'session', json_encode($new_session_data));
             showAdminMainMenu($chat_id, $user_id, $platform);
         }
     } elseif ($action === 'awaiting_discount_expires_at') { 
          $buttons = [];
          if (function_exists('buildBirthYearKeyboard')) {
               $buttons = buildBirthYearKeyboard('discountSet');
          } else {
               $buttons[] = [['text' => 'خطا: کیبورد یافت نشد', 'callback_data'=>'noop']];
          }
          $buttons[] = [['text' => 'بدون تاریخ انقضا', 'callback_data' => buildCallbackData('discountConfirmDate')]];
          if ($can_edit) { editMessage($chat_id, $message_id, "تاریخ انقضای کد تخفیف را انتخاب کنید (یا گزینه بدون انقضا):", ['inline_keyboard' => $buttons]); }
          else { sendMessage($chat_id, "تاریخ انقضای کد تخفیف را انتخاب کنید (یا گزینه بدون انقضا):", ['inline_keyboard' => $buttons], $platform);}
     }
}
?>