<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) { die('No direct script access allowed'); }

function showDiscountList(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
    $offset = (int)($params['offset'] ?? 0);
    $limit = 10;
    $can_edit = ($message_id !== null);

    $codes = getAllDiscountCodes($offset, $limit);
    $total = countAllDiscountCodes();
    $buttons = [];
    $text = '';

    if (empty($codes) && $offset === 0) {
        $text = "هیچ کد تخفیفی یافت نشد.";
        $buttons[] = [['text' => '➕ افزودن کد جدید', 'callback_data' => buildCallbackData('addDiscountStart')]];
        $buttons[] = [['text' => '🔙 بازگشت به منو اصلی', 'callback_data' => buildCallbackData('adminMainMenu')]];
        $reply_markup = ['inline_keyboard' => $buttons];

        if ($can_edit) {
            editMessage($chat_id, $message_id, $text, $reply_markup);
        } else {
            sendMessage($chat_id, $text, $reply_markup, $platform);
        }
        return; // Exit function after handling empty case
    } else {
        $page = floor($offset / $limit) + 1;
        $text = "🎟 *لیست کدهای تخفیف* (صفحه {$page}):\n\n";
        foreach ($codes as $code) {
            $status_icon = $code['is_active'] ? '✅' : '❌';
            $uses = $code['max_uses'] ? "({$code['use_count']}/{$code['max_uses']})" : "({$code['use_count']})";
            $expires = $code['expires_at'] ? date('Y-m-d', strtotime($code['expires_at'])) : 'بدون انقضا';
            $code_display = str_replace(['_', '*', '`', '['], ['\\_', '\\*', '\\`', '\\['], $code['code']);
            $text .= "{$status_icon} `{$code_display}` - {$uses} - {$expires}\n";
            $toggle_text = $code['is_active'] ? 'غیرفعال کردن' : 'فعال کردن';
            $buttons[] = [['text' => "{$code['code']}: {$toggle_text}", 'callback_data' => buildCallbackData('toggleDiscount', ['id' => $code['id'], 'offset' => $offset])]];
        }

        $pagination_row = buildPaginationRow('viewDiscounts', $offset, $limit, $total);
        if (!empty($pagination_row)) {
            $buttons[] = $pagination_row;
        }
         $buttons[] = [['text' => '➕ افزودن کد جدید', 'callback_data' => buildCallbackData('addDiscountStart')]];
    }

    $buttons[] = [['text' => '🔙 بازگشت به منو اصلی', 'callback_data' => buildCallbackData('adminMainMenu')]];
    $reply_markup = ['inline_keyboard' => $buttons];

    if ($can_edit) {
         editMessage($chat_id, $message_id, $text, $reply_markup);
    } else {
         sendMessage($chat_id, $text, $reply_markup, $platform);
    }
}

function handleToggleDiscount(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
     $code_id = (int)($params['id'] ?? 0);
     if ($code_id > 0) {
          toggleDiscountCodeStatus($code_id);
          $offset = (int)($params['offset'] ?? 0);
          showDiscountList(['offset' => $offset], $chat_id, $message_id, $user_id, $platform, $session_data);
     }
}

?>