<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

function startCreateInvoice(int $chat_id, int $user_id, string $platform, array $session_data): void {
    $session_data = ['state' => 'awaiting_invoice_user_id', 'invoice_data' => []];
    updateUserField($user_id, 'session', json_encode($session_data));
    sendMessage($chat_id, "لطفا شناسه کاربری (ID عددی)، شماره موبایل (09) یا شناسه پلتفرم (تلگرام/بله) کاربری که می‌خواهید برای او فاکتور صادر کنید را وارد نمایید:", ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true], $platform);
}

function handleInvoiceUserIdInput(array $message, int $chat_id, int $user_id, string $platform, array $session_data): void {
    $message_text = trim($message['text'] ?? '');
    $target_user = null;

    if (empty($message_text)) {
        sendMessage($chat_id, "ورودی نمی‌تواند خالی باشد. لطفا شناسه کاربر را وارد کنید.", null, $platform);
        return;
    }
    
    $input = convertPersianToEnglishDigits($message_text);

    if (is_numeric($input)) {
        if (strlen($input) >= 10 && strpos($input, '09') === 0) {
            // Search by Phone
            $target_user = getUserByPhoneNumber($input);
        } elseif (strlen($input) < 10) {
            // Search by Internal ID
            $target_user = getUserById((int)$input);
        } else {
            // Search by Platform ID (Telegram/Bale)
            $target_user = getUser((int)$input, 'telegram');
            if (!$target_user) {
                $target_user = getUser((int)$input, 'bale');
            }
        }
    } else {
        sendMessage($chat_id, "فرمت ورودی نامعتبر است. لطفا شناسه عددی یا شماره موبایل را وارد کنید.", null, $platform);
        return;
    }

    if (!$target_user) {
        sendMessage($chat_id, "❌ کاربری با شناسه `{$input}` یافت نشد. لطفا مجددا تلاش کنید.", null, $platform);
        return;
    }

    $session_data['state'] = 'awaiting_invoice_amount';
    $session_data['invoice_data']['target_user_id'] = $target_user['id'];
    $session_data['invoice_data']['target_user_name'] = $target_user['first_name'];
    updateUserField($user_id, 'session', json_encode($session_data));

    sendMessage($chat_id, "✅ کاربر '{$target_user['first_name']}' (ID: {$target_user['id']}) یافت شد.\n\nلطفا مبلغ فاکتور را به *تومان* وارد کنید (فقط عدد):", ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true], $platform);
}

function handleInvoiceAmountInput(array $message, int $chat_id, int $user_id, string $platform, array $session_data): void {
    $message_text = trim($message['text'] ?? '');
    $amount_toman = convertPersianToEnglishDigits($message_text);

    if (!isValidPositiveNumber($amount_toman)) {
        sendMessage($chat_id, "❌ مبلغ نامعتبر است. لطفا یک عدد مثبت (به تومان) وارد کنید.", null, $platform);
        return;
    }

    $session_data['state'] = 'awaiting_invoice_description';
    $session_data['invoice_data']['amount_toman'] = $amount_toman;
    updateUserField($user_id, 'session', json_encode($session_data));

    sendMessage($chat_id, "✅ مبلغ `" . number_format($amount_toman) . "` تومان ثبت شد.\n\nلطفا توضیحات فاکتور را وارد کنید (مثلا: بابت مابه‌التفاوت سفارش ۱۲۳):", ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true], $platform);
}

function handleInvoiceDescriptionInput(array $message, int $chat_id, int $user_id, string $platform, array $session_data): void {
    $description = trim($message['text'] ?? '');

    if (empty($description)) {
        sendMessage($chat_id, "❌ توضیحات فاکتور نمی‌تواند خالی باشد. لطفا دلیل صدور فاکتور را بنویسید.", null, $platform);
        return;
    }
    
    $invoice_data = $session_data['invoice_data'] ?? null;
    if (!$invoice_data || empty($invoice_data['target_user_id']) || empty($invoice_data['amount_toman'])) {
        sendMessage($chat_id, "❌ خطای سیستمی: اطلاعات فاکتور در نشست یافت نشد. عملیات لغو شد.", ['remove_keyboard' => true], $platform);
        updateUserField($user_id, 'session', json_encode(['state' => 'idle']));
        showAdminMainMenu($chat_id, $user_id, $platform);
        return;
    }

    $target_user_id = $invoice_data['target_user_id'];
    $amount_toman = $invoice_data['amount_toman'];
    $target_user_name = $invoice_data['target_user_name'] ?? 'کاربر';
    $final_description = strip_tags($description);

    $order_result = createInvoiceOrder($target_user_id, $amount_toman, $final_description);

    if (!$order_result['success'] || empty($order_result['order_id'])) {
        sendMessage($chat_id, "❌ خطای سیستمی هنگام ایجاد فاکتور در دیتابیس رخ داد: " . ($order_result['message'] ?? 'Unknown'), ['remove_keyboard' => true], $platform);
        updateUserField($user_id, 'session', json_encode(['state' => 'idle']));
        showAdminMainMenu($chat_id, $user_id, $platform);
        return;
    }
    
    $order_id = $order_result['order_id'];
    
    // Notify Admin
    sendMessage($chat_id, "✅ فاکتور آزاد با شماره `{$order_id}` به مبلغ `" . number_format($amount_toman) . "` تومان برای کاربر '{$target_user_name}' با موفقیت صادر شد و لینک پرداخت برای او ارسال گردید.", ['remove_keyboard' => true], $platform);
    updateUserField($user_id, 'session', json_encode(['state' => 'idle']));
    showAdminMainMenu($chat_id, $user_id, $platform);

    // Notify User
    $target_user = getUserById($target_user_id);
    if ($target_user) {
        $payment_page_url = PAYMENT_PAGE_URL . '?order_id=' . $order_id;
        $user_message = "🧾 یک فاکتور جدید از طرف مدیر برای شما صادر شد.\n\n"
                      . "*شماره فاکتور:* `{$order_id}`\n"
                      . "*مبلغ:* `" . number_format($amount_toman) . "` تومان\n"
                      . "*بابت:* {$final_description}\n\n"
                      . "👇 لطفا برای پرداخت روی دکمه زیر کلیک کنید:";
        
        $user_buttons = [[['text' => '💰 پرداخت فاکتور', 'url' => $payment_page_url]]];
        $reply_markup = ['inline_keyboard' => $user_buttons];
        
        if (!empty($target_user['telegram_chat_id'])) {
            sendMessage($target_user['telegram_chat_id'], $user_message, $reply_markup, 'telegram');
        }
        if (!empty($target_user['bale_chat_id'])) {
            sendMessage($target_user['bale_chat_id'], $user_message, $reply_markup, 'bale');
        }
    }
}

?>