<?php
// Prevent direct script access
if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) { die('No direct script access allowed'); }

/**
 * Asks the admin for the order search term (ID).
 * Logic from a.txt admin_handler.php callback 'adminSearchOrder' [cite: 4163-4166]
 */
function askForOrderSearchTerm(int $chat_id, int $user_id, string $platform, array $session_data): void {
    $session_data['state'] = 'awaiting_order_search_term'; // [cite: 4164]
    updateUserField($user_id, 'session', json_encode($session_data));
     sendMessage($chat_id, 'شماره سفارش مورد نظر را وارد کنید:', ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true], $platform); 
}

/**
 * Handles the order search term input and displays the order details.
 * Logic from a.txt admin_handler.php case 'awaiting_order_search_term' [cite: 4427-4435]
 */
function handleOrderSearchTerm(array $message, int $chat_id, int $user_id, string $platform, array $session_data): void {
    $message_text = trim($message['text'] ?? '');
    $order_id_input = convertPersianToEnglishDigits($message_text);

    if (!empty($order_id_input) && is_numeric($order_id_input)) {
        $order_id = (int)$order_id_input;
        $order = getOrderDetails($order_id); 
        if ($order) {
            // Assuming buildAdminOrderDetails exists and returns [$text, $buttons] array
             if (function_exists('buildAdminOrderDetails')) {
                list($admin_message, $buttons) = buildAdminOrderDetails($order); 
                sendMessage($chat_id, $admin_message, ['inline_keyboard' => $buttons, 'remove_keyboard' => true], $platform); 
             } else {
                 // Fallback if buildAdminOrderDetails doesn't exist (should be in FormattingHelpers)
                  sendMessage($chat_id, "جزئیات سفارش:\n" . json_encode($order, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE), ['remove_keyboard' => true], $platform);
             }
        } else {
            sendMessage($chat_id, "سفارشی با شماره `{$order_id}` یافت نشد.", ['remove_keyboard' => true], $platform); 
        }
        $new_session_data = ['state' => 'idle']; 
        updateUserField($user_id, 'session', json_encode($new_session_data)); 
         // Don't call main menu, let admin view the order
    } else {
        sendMessage($chat_id, "لطفا شماره سفارش را به صورت عدد وارد کنید.", null, $platform); 
        // Resend cancel button
         sendMessage($chat_id, "👇", ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true], $platform);
    }
}
?>