<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}


function handleApprovePayout(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
    
    $request_id = (int)($params['id'] ?? 0); 
    $can_edit = ($message_id !== null);
    $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null;
    
    if ($request_id <= 0) { 
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: ID درخواست نامعتبر.', 'show_alert' => true], $platform);
        if ($can_edit) editMessage($chat_id, $message_id, "❌ خطا: ID درخواست نامعتبر است.", null);
        showPendingPayoutsList(['offset' => 0], $chat_id, null, $platform, $session_data);
        return;
    }

    $request = getPayoutRequestDetails($request_id);
    if (!$request || $request['status'] !== 'pending') {
         $text = "⚠️ درخواست تسویه با ID `{$request_id}` یافت نشد یا وضعیت آن در حال انتظار نیست.";
         if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'وضعیت درخواست تغییر کرده است.', 'show_alert' => true], $platform);
         if ($can_edit) editMessage($chat_id, $message_id, $text, null);
         showPendingPayoutsList(['offset' => 0], $chat_id, null, $platform, $session_data);
         return;
    }

    $approved = completePayoutRequest($request_id, $user_id);

    if ($approved) {
        $partner_user_id = $request['partner_user_id'];
        $partner = getUserById($partner_user_id); 
        
        $admin_user = getUserById($user_id);
        $admin_name = $admin_user['first_name'] ?? 'ادمین';
        
        $text = "✅ درخواست تسویه با موفقیت تایید و تکمیل شد.\n";
        $text .= "مبلغ: `" . number_format($request['amount']) . "` تومان\n";
        $text .= "همکار: " . htmlspecialchars($request['first_name'] ?? 'نامشخص') . " (`{$partner_user_id}`)";

        if ($can_edit) {
             editMessage($chat_id, $message_id, $text, null);
        } else {
             sendMessage($chat_id, $text, null, $platform);
        }

        // --- اطلاع رسانی به کاربر همکار ---
        if ($partner) {
            $partner_message = "🎉 *درخواست تسویه شما تکمیل شد!*\n\n";
            $partner_message .= "درخواست تسویه شما به مبلغ `" . number_format($request['amount']) . "` تومان توسط ادمین تایید و پرداخت شد.\n\n";
            $partner_message .= "با تشکر از همکاری شما.";
            
            if (!empty($partner['telegram_chat_id'])) {
                sendPushMessage('telegram', $partner['telegram_chat_id'], $partner_message, getCustomerMainMenuKeyboard($partner)); 
            }
            if (!empty($partner['bale_chat_id'])) {
                sendPushMessage('bale', $partner['bale_chat_id'], $partner_message, getCustomerMainMenuKeyboard($partner));
            }
        }
        
        // --- به‌روزرسانی پیام‌های ادمین در ربات‌ها ---
        deletePayoutRequestMessages($request_id); 
        
        showPendingPayoutsList(['offset' => $session_data['last_payout_offset'] ?? 0], $chat_id, null, $platform, $session_data);


    } else {
         $text = "❌ خطایی در تایید نهایی درخواست تسویه رخ داد. لطفا دوباره تلاش کنید.";
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا در تایید نهایی.', 'show_alert' => true], $platform);
         if ($can_edit) editMessage($chat_id, $message_id, $text, null);
         showPendingPayoutsList(['offset' => $session_data['last_payout_offset'] ?? 0], $chat_id, null, $platform, $session_data);
    }
}

?>