<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

function showPendingPayoutsList(array $params, int $chat_id, ?int $message_id, string $platform, array $session_data): void {
    $offset = (int)($params['offset'] ?? 0);
    $limit = 5; 
    $can_edit = ($message_id !== null);
    
    $requests = getPendingPayoutRequests($offset, $limit);
    $total = countPendingPayoutRequests();
    
    $buttons = [];
    $text = '';

    if (empty($requests) && $offset === 0) {
        $text = "هیچ درخواست تسویه حسابی در حال انتظار یافت نشد.";
    } else {
        $page = floor($offset / $limit) + 1;
        $text = "💳 *لیست درخواست‌های تسویه* (صفحه {$page}):\n\n";
        
        foreach ($requests as $req) {
            $date_fa = to_jalali_datetime($req['created_at']);
            $user_name = htmlspecialchars($req['first_name'] ?? 'کاربر');
            $amount_formatted = number_format($req['amount'] ?? 0);
            
            $buttons[] = [['text' => "{$user_name} - {$amount_formatted} تومان ({$date_fa})", 'callback_data' => buildCallbackData('viewPayout', ['id' => $req['id']])]];
        }

        $pagination_row = buildPaginationRow('viewPayouts', $offset, $limit, $total);
        if (!empty($pagination_row)) {
            $buttons[] = $pagination_row;
        }
    }

    $buttons[] = [['text' => '🔙 بازگشت به منو اصلی', 'callback_data' => buildCallbackData('adminMainMenu')]];
    $reply_markup = ['inline_keyboard' => $buttons];

    if ($can_edit) {
        editMessage($chat_id, $message_id, $text, $reply_markup);
    } else {
        sendMessage($chat_id, $text, $reply_markup, $platform);
    }
}

?>