<?php

// Prevent direct script access
if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

/**
 * Asks for confirmation before deleting (deactivating) a product.
 */
function confirmDeleteProduct(array $params, int $chat_id, ?int $message_id, string $platform): void {
    $product_id = (int)($params['id'] ?? 0);
    $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null;
    $can_edit = ($message_id !== null);
    $is_photo_message = $can_edit && isset($GLOBALS['update']['callback_query']['message']['photo']);

    if ($product_id <= 0) {
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: محصول نامشخص.', 'show_alert' => true], $platform);
        return;
    }

    $product = getProduct($product_id); // Assumes ProductQueries loaded
    if (!$product) {
         if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: محصول یافت نشد.', 'show_alert' => true], $platform);
         // Optionally remove the message if it exists
         if ($can_edit) apiRequest('deleteMessage', ['chat_id' => $chat_id, 'message_id' => $message_id], $platform);
         return;
    }

    $product_name = htmlspecialchars($product['name'] ?? 'محصول');
    $confirm_text = "آیا از حذف محصول '{$product_name}' مطمئن هستید؟\n(این عمل محصول را غیرفعال می‌کند و از فروشگاه پنهان می‌سازد)";
    $buttons = [
        [['text' => '❌ بله، حذف (غیرفعال) کن', 'callback_data' => buildCallbackData('confirmDelete', ['id' => $product_id])]],
        [['text' => 'انصراف', 'callback_data' => buildCallbackData('editProd', ['id' => $product_id])]] // Go back to edit options
    ];
    $reply_markup = ['inline_keyboard' => $buttons];

    if ($can_edit) {
        // Edit the existing message (text or caption)
        editMessage($chat_id, $message_id, $confirm_text, $reply_markup, $is_photo_message);
    } else {
        // Should not happen if triggered from inline button, but as fallback:
        sendMessage($chat_id, $confirm_text, $reply_markup, $platform);
    }
}

/**
 * Handles the actual deletion (deactivation) of the product.
 */
function handleDeleteProduct(array $params, int $chat_id, ?int $message_id, string $platform): void {
    $product_id = (int)($params['id'] ?? 0);
    $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null;
    $can_edit = ($message_id !== null);
    $is_photo_message = $can_edit && isset($GLOBALS['update']['callback_query']['message']['photo']);

    if ($product_id <= 0) {
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: محصول نامشخص.', 'show_alert' => true], $platform);
        return;
    }

    if (deleteProduct($product_id)) { // Assumes ProductQueries loaded
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'محصول غیرفعال شد.'], $platform);
        $success_text = 'محصول با موفقیت حذف (غیرفعال) شد.';
         if ($can_edit) {
             // Edit message to show success, remove buttons
             editMessage($chat_id, $message_id, $success_text, null, $is_photo_message);
         } else {
             sendMessage($chat_id, $success_text, null, $platform);
         }
         // Optionally, prompt to go back to product list or main menu
         // showProductList($chat_id, 0, $platform);
    } else {
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا در غیرفعال کردن محصول.', 'show_alert' => true], $platform);
        // Optionally edit the message to show the error
    }
}

?>
