<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

function showEditOptions(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
    $product_id = (int)($params['id'] ?? 0);
    $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null;
    $can_edit = ($message_id !== null);
    $is_photo_message = $can_edit && isset($GLOBALS['update']['callback_query']['message']['photo']);

    if ($product_id <= 0) {
         if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: محصول نامشخص.', 'show_alert' => true], $platform);
        return;
    }

    $product = getProduct($product_id);
    if (!$product) {
         if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: محصول یافت نشد.', 'show_alert' => true], $platform);
         if ($can_edit) apiRequest('deleteMessage', ['chat_id' => $chat_id, 'message_id' => $message_id], $platform);
         return;
    }

    $session_data['editing_product_id'] = $product_id;
    updateUserField($user_id, 'session', json_encode($session_data));

    $product_name = htmlspecialchars($product['name'] ?? 'محصول');
    $text = "کدام بخش از محصول '{$product_name}' را می‌خواهید ویرایش کنید؟";
    
    $buttons = [];
    $buttons[] = [['text' => '🖼 ویرایش عکس اصلی', 'callback_data' => buildCallbackData('editProdPhoto', ['id' => $product_id])]];
    $buttons[] = [['text' => 'ویرایش نام', 'callback_data' => buildCallbackData('editField', ['field' => 'name'])], ['text' => 'ویرایش توضیحات', 'callback_data' => buildCallbackData('editField', ['field' => 'description'])]];

    if ($product['type'] === 'simple') {
        $buttons[] = [['text' => 'ویرایش قیمت', 'callback_data' => buildCallbackData('editField', ['field' => 'price'])], ['text' => 'ویرایش واحد', 'callback_data' => buildCallbackData('editField', ['field' => 'unit'])]];
        $buttons[] = [['text' => 'ویرایش موجودی', 'callback_data' => buildCallbackData('editField', ['field' => 'stock'])]];
        $buttons[] = [['text' => 'ویرایش وزن', 'callback_data' => buildCallbackData('editField', ['field' => 'weight'])], ['text' => 'ویرایش واحد وزن', 'callback_data' => buildCallbackData('editField', ['field' => 'weight_unit'])]];
    } elseif ($product['type'] === 'variable') {
        $buttons[] = [['text' => 'ویرایش واحد', 'callback_data' => buildCallbackData('editField', ['field' => 'unit'])]];
        $buttons[] = [['text' => '🧬 مدیریت ویژگی‌ها', 'callback_data' => buildCallbackData('editProdAttributes', ['id' => $product_id])]];
        $buttons[] = [['text' => '🔧 مدیریت ترکیب‌ها', 'callback_data' => buildCallbackData('listVariations', ['id' => $product_id, 'offset' => 0])]];
    }

    $buttons[] = [['text' => '🎁 مدیریت تخفیف محصول', 'callback_data' => buildCallbackData('manageProdDiscount', ['id' => $product_id])]];
    $buttons[] = [['text' => '👤 تخصیص انباردار', 'callback_data' => buildCallbackData('setSteward', ['id' => $product_id, 'offset' => 0])]];
    $buttons[] = [['text' => '🔙 بازگشت به لیست محصولات', 'callback_data' => buildCallbackData('adminPage', ['offset' => $session_data['last_product_offset'] ?? 0])]];

    $reply_markup = ['inline_keyboard' => $buttons];

    if ($can_edit) {
      editMessage($chat_id, $message_id, $text, $reply_markup, $is_photo_message);
    } else {
        sendMessage($chat_id, $text, $reply_markup, $platform);
    }
}

function askForNewPhoto(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
    $product_id = (int)($params['id'] ?? ($session_data['editing_product_id'] ?? 0));
    
    if ($product_id <= 0) {
        sendMessage($chat_id, "خطا: محصول نامشخص است.", null, $platform);
        return;
    }
    
    $session_data['state'] = 'editing_product_photo';
    $session_data['editing_product_id'] = $product_id;
    updateUserField($user_id, 'session', json_encode($session_data));

    if ($message_id) {
        apiRequest('deleteMessage', ['chat_id' => $chat_id, 'message_id' => $message_id], $platform);
    }

    sendMessage(
        $chat_id, 
        "لطفا عکس جدید محصول را ارسال کنید:", 
        ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true], 
        $platform
    );
}


function handleNewPhoto(array $message, int $chat_id, int $user_id, string $platform, array $session_data): void {
    $product_id = $session_data['editing_product_id'] ?? null;

    if (!$product_id) {
        sendMessage($chat_id, "خطا: محصول مورد نظر برای ویرایش عکس مشخص نیست. عملیات لغو شد.", ['remove_keyboard' => true], $platform);
        updateUserField($user_id, 'session', json_encode(['state' => 'idle']));
        showAdminMainMenu($chat_id, $user_id, $platform);
        return;
    }

    if (isset($message['photo'])) {
        $photo_array = $message['photo'];
        $source_file_id = end($photo_array)['file_id'];

        sendMessage($chat_id, "⏳ در حال پردازش و ذخیره‌سازی عکس جدید...", null, $platform);
        
        $product_before_update = getProduct($product_id);
        $old_image_path = $product_before_update['image_path'] ?? null;
        
        $saved_filename = downloadAndSaveFile($source_file_id, $platform, PRODUCT_IMAGE_STORAGE_PATH);

        if ($saved_filename) {
            updateProductField($product_id, 'image_path', $saved_filename);

            if ($old_image_path && file_exists(PRODUCT_IMAGE_STORAGE_PATH . '/' . $old_image_path)) {
                @unlink(PRODUCT_IMAGE_STORAGE_PATH . '/' . $old_image_path);
            }
            
             sendMessage($chat_id, "✅ عکس محصول با موفقیت به‌روزرسانی شد.", ['remove_keyboard' => true], $platform);
            updateUserField($user_id, 'session', json_encode(['state' => 'idle', 'editing_product_id' => null]));
            showAdminMainMenu($chat_id, $user_id, $platform);
        } else {
            sendMessage($chat_id, 
              "❌ خطا در ذخیره‌سازی عکس جدید. لطفا دوباره تلاش کنید یا انصراف دهید.", null, $platform);
        }
    } else {
        sendMessage($chat_id, "لطفا فقط عکس جدید محصول را ارسال کنید یا انصراف دهید.", null, $platform);
    }
}


function askForFieldValue(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
     $field_to_edit = $params['field'] ?? null;
     $product_id = $session_data['editing_product_id'] ?? null;

     $allowed_fields = ['name', 'description', 'price', 'unit', 'stock', 'weight', 'weight_unit'];
 
     if (!$field_to_edit || !$product_id || !in_array($field_to_edit, $allowed_fields)) {
         sendMessage($chat_id, "خطا: اطلاعات ویرایش ناقص یا فیلد نامعتبر است.", null, $platform);
         updateUserField($user_id, 'session', json_encode(['state' => 'idle', 'editing_product_id' => null]));
         showAdminMainMenu($chat_id, $user_id, $platform);
         
    return;
     }

    $session_data['state'] = 'admin_editing_field';
    $session_data['field_to_edit'] = $field_to_edit;
    updateUserField($user_id, 'session', json_encode($session_data));

    if ($message_id) {
        apiRequest('deleteMessage', ['chat_id' => $chat_id, 'message_id' => $message_id], $platform);
    }

    $product = getProduct($product_id);
    $current_value_text = $product[$field_to_edit] ?? 'تعریف نشده';

    if (in_array($field_to_edit, ['stock', 'weight', 'weight_unit']) && $current_value_text === null) {
        $current_value_text = 'نامحدود (null)';
    }

    $prompt = "ویرایش فیلد '{$field_to_edit}'\n";
    $prompt .= "مقدار فعلی: `{$current_value_text}`\n\n";
    $prompt .= "لطفا مقدار جدید را ارسال کنید:";
    
    if ($field_to_edit === 'stock' || $field_to_edit === 'weight' || $field_to_edit === 'weight_unit') {
         $prompt .= "\n(برای ثبت نشدن، کلمه `null` را بفرستید)";
    }
    
    sendMessage(
        $chat_id, 
        $prompt, 
        ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true], 
        $platform
    );
}


function handleFieldValueInput(array $message, int $chat_id, int $user_id, string $platform, array $session_data): void {
    $product_id = $session_data['editing_product_id'] ?? null;
    $field = $session_data['field_to_edit'] ?? null;
    $new_value_raw = trim($message['text'] ?? '');

    if (!$product_id || !$field) {
        sendMessage($chat_id, "خطا: اطلاعات ویرایش یافت نشد. عملیات لغو شد.", ['remove_keyboard' => true], $platform);
        updateUserField($user_id, 'session', json_encode(['state' => 'idle']));
       showAdminMainMenu($chat_id, $user_id, $platform);
        return;
    }

    $new_value = $new_value_raw;
    $valid = false;
    $error_message = "مقدار وارد شده نامعتبر است.";

    if (in_array($field, ['stock', 'weight'])) {
        if (strtolower($new_value) === 'null') {
            $new_value = null; 
            $valid = true;
          } elseif (isValidNonNegativeNumber($new_value)) {
           $new_value = convertPersianToEnglishDigits($new_value);
            $valid = true;
        } else {
             $error_message = "لطفا مقدار را به صورت عدد معتبر (مثلا `10` یا `5.5`) یا کلمه `null` وارد کنید.";
        }
    } elseif ($field === 'price') {
      
      if (isValidNonNegativeNumber($new_value)) {
             $new_value = convertPersianToEnglishDigits($new_value);
             $valid = true;
        } else {
            $error_message = "لطفا قیمت را به صورت عدد صحیح یا اعشاری معتبر وارد کنید (مثال: `150000`).";
        }
    } elseif ($field === 'weight_unit') {
        if (strtolower($new_value) === 'null') {
            $new_value = null;
            $valid = true;
        } elseif (!empty($new_value)) {
            $new_value = strip_tags($new_value);
            $valid = true;
        } else {
            $error_message = "واحد وزن نمی‌تواند خالی باشد (یا 'null' را بفرستید).";
        }
    } elseif (in_array($field, ['name', 'description', 'unit'])) {
        if (!empty($new_value)) {
            $new_value = strip_tags($new_value);
            $valid = true;
        } else {
            $error_message = "مقدار فیلد '{$field}' نمی‌تواند خالی باشد.";
        }
    }
    
    
    if ($valid) {
        if (updateProductField($product_id, $field, $new_value)) {
             sendMessage($chat_id, "✅ مقدار '{$field}' با موفقیت به‌روزرسانی شد.", ['remove_keyboard' => true], $platform);
            updateUserField($user_id, 'session', json_encode(['state' => 'idle', 'editing_product_id' => null, 
'field_to_edit' => null]));
           showAdminMainMenu($chat_id, $user_id, $platform);
        } else {
             sendMessage($chat_id, "❌ خطایی در به‌روزرسانی محصول رخ داد.", ['remove_keyboard' => true], $platform);
             updateUserField($user_id, 'session', json_encode(['state' => 'idle', 'editing_product_id' => null, 'field_to_edit' => null]));
             showAdminMainMenu($chat_id, $user_id, $platform);
        }
    } else {
        sendMessage($chat_id, "❌ " . $error_message . " لطفا دوباره تلاش کنید یا انصراف دهید.", null, $platform);
    }
}

?>