<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

// --- Gateway Management Module ---

/**
 * Displays the gateway settings menu.
 */
function showGatewaySettings(int $chat_id, ?int $message_id, string $platform): void {
    // نیاز به SettingQueries.php است که در AdminHandler لود می‌شود
    $active_gateway = getActiveGateway(); 

    $text = "⚙️ *تنظیمات درگاه پرداخت*\n\n";
    $text .= "درگاه فعال فعلی: *" . ($active_gateway === 'zibal' ? '⚫️ زیبال' : '🔵 زرین‌پال') . "*\n\n";
    $text .= "لطفا درگاه مورد نظر خود را برای تمام تراکنش‌ها انتخاب کنید (تغییر بلافاصله اعمال می‌شود):";

    $btn_zarinpal_text = ($active_gateway === 'zarinpal') ? '✅ زرین‌پال (فعال)' : '🔵 فعال‌سازی زرین‌پال';
    $btn_zibal_text = ($active_gateway === 'zibal') ? '✅ زیبال (فعال)' : '⚫️ فعال‌سازی زیبال';

    $buttons = [
        [['text' => $btn_zarinpal_text, 'callback_data' => buildCallbackData('setGateway', ['gw' => 'zarinpal'])]],
        [['text' => $btn_zibal_text, 'callback_data' => buildCallbackData('setGateway', ['gw' => 'zibal'])]],
        [['text' => '🔙 بازگشت به منو اصلی', 'callback_data' => buildCallbackData('adminMainMenu')]]
    ];

    $reply_markup = ['inline_keyboard' => $buttons];

    if ($message_id) {
        editMessage($chat_id, $message_id, $text, $reply_markup);
    } else {
        sendMessage($chat_id, $text, $reply_markup, $platform);
    }
}

/**
 * Handles the callback to switch the active gateway.
 */
function handleGatewaySwitch(array $params, int $chat_id, int $message_id, string $platform): void {
    $requested_gateway = $params['gw'] ?? '';
    $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null;

    if (!in_array($requested_gateway, ['zarinpal', 'zibal'])) {
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: درگاه نامعتبر.', 'show_alert' => true], $platform);
        return;
    }

    if (setActiveGateway($requested_gateway)) {
        $msg = ($requested_gateway === 'zibal') ? 'درگاه زیبال فعال شد.' : 'درگاه زرین‌پال فعال شد.';
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => $msg], $platform);
    } else {
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا در ذخیره تنظیمات.', 'show_alert' => true], $platform);
    }

    // Refresh the view to update buttons
    showGatewaySettings($chat_id, $message_id, $platform);
}

?>