<?php
// Prevent direct script access
if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) { die('No direct script access allowed'); }

/**
 * Asks the admin for the message to send to the user.
 *Logic from a.txt admin_handler.php case 'messageUser' 
 */
function askForMessageToUser(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
    $target_user_id = (int)($params['id'] ?? 0); 
    if ($target_user_id > 0) {
        $stmt_target = pdo()->prepare("SELECT telegram_user_id, bale_user_id, telegram_chat_id, bale_chat_id, first_name FROM users WHERE id=?"); 
        $stmt_target->execute([$target_user_id]); 
        $target_user_obj = $stmt_target->fetch(); 
        if ($target_user_obj) {
             $session_data['state'] = 'awaiting_direct_message';
             $session_data['target_user_id'] = $target_user_id;
             $session_data['target_user_telegram_chat_id'] = $target_user_obj['telegram_chat_id']; 
             $session_data['target_user_bale_chat_id'] = $target_user_obj['bale_chat_id'];
             $target_user_name = $target_user_obj['first_name'] ?? "کاربر {$target_user_id}";
             updateUserField($user_id, 'session', json_encode($session_data));
             // Delete previous message if possible
             if ($message_id) { apiRequest('deleteMessage', ['chat_id' => $chat_id, 'message_id' => $message_id], $platform);}
             sendMessage($chat_id, "لطفا پیام خود را برای کاربر '{$target_user_name}' ارسال کنید:", ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true], $platform); 
        } else {
             sendMessage($chat_id, "خطا: کاربر مورد نظر یافت نشد.", null, $platform); 
             // Optionally go back to user list or main menu
             showAdminMainMenu($chat_id, $user_id, $platform);
        }
    }
}

/**
 * Handles the admin's message and sends it to the target user.
 * Logic from a.txt admin_handler.php case 'awaiting_direct_message' [cite: 4347-4361]
 */
function handleDirectMessageInput(array $message, int $chat_id, int $user_id, string $platform, array $session_data): void {
    $message_text = trim($message['text'] ?? '');
     if (isset($session_data['target_user_id']) && !empty($message_text)) {
         $target_user_id = $session_data['target_user_id'];
         $admin_message_to_user = "پیام از طرف مدیر:\n\n" . $message_text;
         $target_telegram_chat_id = $session_data['target_user_telegram_chat_id'] ?? null; 
         $target_bale_chat_id = $session_data['target_user_bale_chat_id'] ?? null; 
         $success_sent = false;

         if ($target_telegram_chat_id) {
             sendMessage($target_telegram_chat_id, $admin_message_to_user, null, 'telegram'); 
             $success_sent = true; 
         }
         if ($target_bale_chat_id) {
             sendMessage($target_bale_chat_id, $admin_message_to_user, null, 'bale');
             $success_sent = true; 
         }

         if ($success_sent) {
             sendMessage($chat_id, "✅ پیام شما با موفقیت ارسال شد.", ['remove_keyboard' => true], $platform); 
         } else {
             sendMessage($chat_id, "❌ خطا در ارسال پیام. ممکن است کاربر در هیچ پلتفرمی در دسترس نباشد یا چت آی‌دی معتبر نباشد.", ['remove_keyboard' => true], $platform);
         }
         $new_session_data = ['state' => 'idle']; 
         updateUserField($user_id, 'session', json_encode($new_session_data));
         showAdminMainMenu($chat_id, $user_id, $platform); // Go back to main menu
     } else {
         sendMessage($chat_id, "پیام نمی‌تواند خالی باشد. لطفا پیام خود را ارسال کنید یا انصراف دهید.", null, $platform);
         // Resend cancel button
         sendMessage($chat_id, "👇", ['keyboard' => [[['text' => 'انصراف و بازگشت به منو']]], 'resize_keyboard' => true], $platform);
     }
}
?>