<?php
// Prevent direct script access
if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed'); //
}

/**
 * Asks for confirmation before deleting a card.
 * Logic from a.txt customer_handler.php, case 'deleteCardPrompt' callback [cite: 5198-5208]
 */
function confirmDeleteCard(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform): void {
    $card_id_to_delete = (int)($params['card_id'] ?? 0); //
    $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null; //
    $can_edit = ($message_id !== null); //

    if ($card_id_to_delete <= 0) {
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: کارت نامشخص.', 'show_alert' => true], $platform); //
        return; //
    }

    // Get masked number for confirmation message
    $card_mask_to_delete = ''; //
    $user_cards = getUserCards($user_id); //
    foreach($user_cards as $card) {
        if (($card['id'] ?? 0) == $card_id_to_delete) { //
            $card_mask_to_delete = $card['card_number_masked'] ?? ''; //
            break; //
        }
    }

    if ($card_mask_to_delete) { //
        $confirm_text = "❓ آیا از حذف کارت `{$card_mask_to_delete}` مطمئن هستید؟"; //
        $confirm_buttons = [
            [['text' => '❌ بله، حذف کن', 'callback_data' => buildCallbackData('deleteCardExecute', ['card_id' => $card_id_to_delete])]], //
            [['text' => 'انصراف', 'callback_data' => buildCallbackData('manageCards')]] // Go back to card list
        ]; //
        $reply_markup = ['inline_keyboard' => $confirm_buttons]; //

        if ($can_edit) {
            editMessage($chat_id, $message_id, $confirm_text, $reply_markup); //
        } else {
            sendMessage($chat_id, $confirm_text, $reply_markup, $platform); //
        }
    } else {
        // Card not found or doesn't belong to user
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: کارت یافت نشد.', 'show_alert' => true], $platform); //
        // Refresh card list
        showCardList([], $chat_id, $message_id, $user_id, $platform); //
    }
}

/**
 * Executes the card deletion.
 * Logic from a.txt customer_handler.php, case 'deleteCardExecute' callback [cite: 5209-5220]
 */
function handleDeleteCard(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform): void {
    $card_id_to_delete = (int)($params['card_id'] ?? 0); //
    $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null; //

    if ($card_id_to_delete <= 0) {
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: کارت نامشخص.', 'show_alert' => true], $platform); //
        return; //
    }

    if (deleteUserCard($card_id_to_delete, $user_id)) { //
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'کارت با موفقیت حذف شد.'], $platform); //
    } else {
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا در حذف کارت.', 'show_alert' => true], $platform); //
    }

    // Refresh the card list view
    showCardList([], $chat_id, $message_id, $user_id, $platform); //
}
?>