<?php
// Prevent direct script access
if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed'); //
}

/**
 * Asks for confirmation before clearing the cart.
 * Logic from a.txt customer_handler.php, case 'clearCartConfirm' callback [cite: 4962-4966]
 */
function confirmClearCart(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform): void {
     $buttons = [
         [['text' => '❌ بله، خالی کن', 'callback_data' => buildCallbackData('clearCartExecute')]], //
         [['text' => '🛒 بازگشت به سبد خرید', 'callback_data' => buildCallbackData('viewCart')]] //
     ]; //
     $reply_markup = ['inline_keyboard' => $buttons]; //
     $text = "❓ آیا از خالی کردن کامل سبد خرید خود مطمئن هستید؟"; //

     if ($message_id) {
         editMessage($chat_id, $message_id, $text, $reply_markup); //
     } else {
         sendMessage($chat_id, $text, $reply_markup, $platform); //
     }
}

/**
 * Handles the execution of clearing the cart after confirmation.
 * Logic from a.txt customer_handler.php, case 'clearCartExecute' callback [cite: 4967-4973]
 */
function handleClearCart(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform): void {
     $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null; //

     if (clearCart($user_id)) { //
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'سبد خرید خالی شد.'], $platform); //
     } else {
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا در خالی کردن سبد.', 'show_alert' => true], $platform); //
     }

     // Refresh the cart view (which will now be empty)
     showCart($chat_id, $user_id, $message_id, $platform); //
}
?>