<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

function showPaymentConfirmation(int $chat_id, int $user_id, ?int $message_id, string $platform, array $session_data, array $user, ?string $prefix_message = null): void {
    // استفاده از توابع موجود در FormattingHelpers.php
    $summary_text = buildOrderSummaryTextInternal($user_id, $session_data, $user);
    $buttons = buildPaymentConfirmationButtonsInternal($user_id, $session_data, $user);

    $message_body = ($prefix_message ? $prefix_message . "\n\n" : '') . $summary_text . "\n\nلطفا اطلاعات سفارش را بررسی و تایید کنید.";
    $reply_markup_inline_only = ['inline_keyboard' => $buttons];

    if ($message_id) {
        editMessage($chat_id, $message_id, $message_body, $reply_markup_inline_only);
    } else {
        sendMessage($chat_id, "پیش‌فاکتور:", getCustomerMainMenuKeyboard($user), $platform);
        sendMessage($chat_id, $message_body, $reply_markup_inline_only, $platform);
    }
}

function handleConfirmation(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data, array $user): void {
    $checkout_data = $session_data['checkout'] ?? [];
    $selected_card_id = $session_data['selected_card_id'] ?? null;
    $cart_items = getCartContents($user_id);

    $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null;
    $can_edit = ($message_id !== null);

    if ($can_edit) {
        apiRequest('deleteMessage', ['chat_id' => $chat_id, 'message_id' => $message_id], $platform);
        $message_id = null;
        $can_edit = false;
    }

    $is_valid = true;
    $missing_info = [];

    if (empty($cart_items)) {
        $is_valid = false;
        $missing_info[] = 'سبد خرید خالی';
    }
    
    // طبق سناریوی جدید: همه کاربران (همکار و مشتری همکار) باید کارت انتخاب کنند
    if (empty($selected_card_id) || $selected_card_id <= 0) {
         $is_valid = false;
         $missing_info[] = 'کارت پرداخت';
    }

    if (empty($checkout_data['province']) || empty($checkout_data['city']) || empty($checkout_data['address_text']) || empty($checkout_data['postal_code'])) {
        $is_valid = false;
        $missing_info[] = 'آدرس';
    }

    if (!$is_valid) {
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: اطلاعات سفارش ناقص است: ' . implode(', ', $missing_info), 'show_alert' => true], $platform);
        $error_prefix = "⚠️ لطفا اطلاعات ناقص را تکمیل کنید: " . implode(' و ', $missing_info);
        showPaymentConfirmation($chat_id, $user_id, null, $platform, $session_data, $user, $error_prefix);
        return;
    }

    $subtotal = '0.00';
    foreach ($cart_items as $item) {
        $subtotal = bcadd($subtotal, bcmul((string)($item['quantity'] ?? '0'), (string)($item['pricing']['price'] ?? '0.00'), BC_SCALE), BC_SCALE);
    }
    $discount_code = $checkout_data['discount_code'] ?? null;
    $discount_amount = $checkout_data['discount_amount'] ?? '0.00';
    $note = $checkout_data['note'] ?? null;

    $full_address = ($checkout_data['province'] ?? '') . ', ' . ($checkout_data['city'] ?? '') . ', '
                    . ($checkout_data['address_text'] ?? '')
                    . ' (کدپستی: ' . ($checkout_data['postal_code'] ?? '') . ')';

    $order_result = createOrder(
        $user_id,
        $checkout_data['province'] ?? '',
        $checkout_data['city'] ?? '',
        $full_address,
        $cart_items,
        $note,
        $subtotal,
        'awaiting_online_payment',
        $discount_code,
        $discount_amount,
        'product',
        $selected_card_id
    );

    if (!$order_result['success']) {
        $error_msg = "❌ خطایی هنگام ثبت سفارش رخ داد.";
        if (($order_result['error'] ?? '') === 'out_of_stock') {
            $error_msg .= "\n\nمتاسفانه موجودی محصولات زیر به اتمام رسیده است:\n" . implode("\n", array_map('htmlspecialchars', $order_result['products'] ?? []));
            if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'موجودی برخی محصولات تمام شده!', 'show_alert' => true], $platform);
            showCart($chat_id, $user_id, null, $platform, $user);
        } else {
            $error_msg .= "\n" . ($order_result['message'] ?? 'لطفا دوباره تلاش کنید یا با پشتیبانی تماس بگیرید.');
            if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا در ثبت سفارش.', 'show_alert' => true], $platform);
            sendMessage($chat_id, $error_msg, getCustomerMainMenuKeyboard($user), $platform);
        }
       return;
    }

    $order_id = $order_result['order_id'];
    $total_amount_toman = $order_result['total_amount'];
    $stewards_to_notify = $order_result['stewards_to_notify'] ?? [];

    clearCart($user_id);
    updateUserField($user_id, 'session', json_encode(['state' => 'idle']));
    
    $payment_page_url = PAYMENT_PAGE_URL . '?order_id=' . $order_id; 

    $payment_message = "✅ سفارش شما با شماره `{$order_id}` با موفقیت ثبت شد.\n\n"
                     . "💰 مبلغ محصولات: `" . number_format($total_amount_toman) . "` تومان\n"
                     . "🚚 هزینه ارسال: (پس از بررسی توسط مدیریت محاسبه و جداگانه دریافت می‌شود)\n\n"
                     . "👇 لطفا برای پرداخت مبلغ محصولات روی دکمه زیر کلیک کنید:";

    $payment_buttons = [[['text' => '💰 پرداخت آنلاین (محصولات)', 'url' => $payment_page_url]]]; 
    $reply_markup_inline_only = ['inline_keyboard' => $payment_buttons];

    sendMessage($chat_id, "سفارش شما ثبت شد.", getCustomerMainMenuKeyboard($user), $platform);
    sendMessage($chat_id, $payment_message, $reply_markup_inline_only, $platform);
    
    // Notify Stewards
    if (!empty($stewards_to_notify)) {
         try {
             $order_details = getOrderDetails($order_id);
            if ($order_details) {
                $steward_message = "📦 *سفارش جدید برای انبار شما ثبت شد.*\n\n" . buildAdminOrderDetailsText($order_details);
                $steward_buttons = [[['text' => '👀 مشاهده سفارش در پنل ادمین', 'callback_data' => buildCallbackData('viewOrder', ['id' => $order_id])]]];
                
                $steward_ids_placeholders = implode(',', array_fill(0, count($stewards_to_notify), '?'));
                $stmt = pdo()->prepare("SELECT telegram_chat_id, bale_chat_id FROM users WHERE id IN ($steward_ids_placeholders) AND is_active = TRUE");
                $stmt->execute($stewards_to_notify);
                $stewards = $stmt->fetchAll();
                
                foreach ($stewards as $steward) {
                    if (!empty($steward['telegram_chat_id'])) {
                          sendPushMessage('telegram', $steward['telegram_chat_id'], $steward_message, ['inline_keyboard' => $steward_buttons]);
                    }
                    if (!empty($steward['bale_chat_id'])) {
                       sendPushMessage('bale', $steward['bale_chat_id'], $steward_message, ['inline_keyboard' => $steward_buttons]);
                    }
                    usleep(100000); 
                }
            }
        } catch (Exception $e) {
            if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - CRITICAL Error: Failed to notify stewards for order {$order_id}: " . $e->getMessage() . "\n", FILE_APPEND); }
        }
    }

    // Notify Partner
    $partner_user_id = $user['referred_by_user_id'] ?? null;
    if ($partner_user_id) {
        try {
            $partner = getUserById($partner_user_id);
            if ($partner) {
                $order_details_for_partner = getOrderDetails($order_id);
                 if ($order_details_for_partner) {
                    $partner_message = "🛍 *سفارش جدید از مشتری شما ثبت شد.*\n\n" . buildPartnerCustomerOrderDetailsText($order_details_for_partner);
                    
                    if (!empty($partner['telegram_chat_id'])) {
                        sendPushMessage('telegram', $partner['telegram_chat_id'], $partner_message, null);
                    }
                    if (!empty($partner['bale_chat_id'])) {
                        sendPushMessage('bale', $partner['bale_chat_id'], $partner_message, null);
                    }
                }
            }
        } catch (Exception $e) {
            if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - Error: Failed to notify partner {$partner_user_id} for order {$order_id}: " . $e->getMessage() . "\n", FILE_APPEND); }
        }
    }
}
?>