<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

function handleNoteInput(array $message, int $chat_id, int $user_id, string $platform, array $session_data, array $user): void {
    $note_text = trim($message['text'] ?? '');

    if ($note_text === 'رد شدن و ادامه') {
        $note_text = ''; 
    }

    $session_data['checkout']['note'] = strip_tags($note_text);
    $session_data['state'] = 'awaiting_payment_confirmation'; 
    updateUserField($user_id, 'session', json_encode($session_data));

    
    sendMessage($chat_id, "یادداشت شما ثبت شد.", ['remove_keyboard' => true], $platform);

    
    // FIX: Passing $user as the 6th argument and null (for $prefix_message) as the 7th argument
    // Signature: showPaymentConfirmation(int $chat_id, int $user_id, ?int $message_id, string $platform, array $session_data, array $user, ?string $prefix_message = null)
    showPaymentConfirmation(
        $chat_id, 
        $user_id, 
        null, 
        $platform, 
        $session_data, 
        $user,     // <-- Arg 6: array $user 
        null      // <-- Arg 7: ?string $prefix_message
    ); 
}

?>