<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

function showCustomerProductOrderList(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $user): void {
    $offset = (int)($params['offset'] ?? 0);
    $limit = defined('CUSTOMER_ORDERS_PER_PAGE') ? CUSTOMER_ORDERS_PER_PAGE : 5;
    $can_edit = ($message_id !== null);
    
    $orders = getOrdersByUserPaginated($user_id, $limit, $offset, 'product');
    $total_orders = countOrdersByUser($user_id, 'product');
    $buttons = [];

    if ($total_orders == 0) {
        $text = "شما هیچ سفارش محصولی ثبت نکرده‌اید.";
    } else {
        $page = floor($offset / $limit) + 1;
        $text = "📦 *لیست سفارشات محصول شما* (صفحه {$page}):\n\nبرای مشاهده جزئیات، روی هر مورد کلیک کنید.";
         foreach ($orders as $order) {
            $order_id_safe = $order['id'] ?? 0;
            $status_safe = $order['status'] ?? 'نامشخص';
            $created_at_safe = $order['created_at'] ?? null;
            $order_type = $order['order_type'] ?? 'product';
            
            $type_fa = 'سفارش';
            
            $status_fa = translate_status_to_persian($status_safe);
              $date_fa = to_jalali_datetime($created_at_safe);
            if ($order_id_safe > 0) {
                $buttons[] = 
[['text' => "{$type_fa} #{$order_id_safe} - {$status_fa} - {$date_fa}", 'callback_data' => buildCallbackData('viewCustProdOrder', ['id' => $order_id_safe])]];
            }
        }

        $pagination_row = buildPaginationRow('custProdOrderPage', $offset, $limit, $total_orders);
    
        if (!empty($pagination_row)) {
            $buttons[] = $pagination_row;
        }
    }
    
    $buttons[] = [['text' => '🔙 بازگشت به منو اصلی', 
'callback_data' => buildCallbackData('mainMenu')]];
    $reply_markup_inline_only = ['inline_keyboard' => $buttons];

     if ($can_edit) {
         editMessage($chat_id, $message_id, $text, $reply_markup_inline_only);
     } else {
       
   $mainMenuKeyboard = getCustomerMainMenuKeyboard($user);
         $mainMenuKeyboard['inline_keyboard'] = $buttons;
         sendMessage($chat_id, $text, $mainMenuKeyboard, $platform);
     }
}

function showCustomerInvoiceOrderList(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $user): void {
    $offset = (int)($params['offset'] ?? 0);
    $limit = defined('CUSTOMER_ORDERS_PER_PAGE') ? CUSTOMER_ORDERS_PER_PAGE : 5;
    $can_edit = ($message_id !== null);
    
    $orders = getOrdersByUserPaginated($user_id, $limit, $offset, 'invoice');
    $total_orders = countOrdersByUser($user_id, 'invoice');
    $buttons = [];

    if ($total_orders == 0) {
        $text = "شما هیچ فاکتور آزادی ثبت نکرده‌اید.";
    } else {
        $page = floor($offset / $limit) + 1;
        $text = "🧾 *لیست فاکتورهای آزاد شما* (صفحه {$page}):\n\nبرای مشاهده جزئیات، روی هر مورد کلیک کنید.";
         foreach ($orders as $order) {
            $order_id_safe = $order['id'] ?? 0;
            $status_safe = $order['status'] ?? 'نامشخص';
            $created_at_safe = $order['created_at'] ?? null;
            $order_type = $order['order_type'] ?? 'invoice';
            
            $type_fa = 'فاکتور';
            
            $status_fa = translate_status_to_persian($status_safe);
              $date_fa = to_jalali_datetime($created_at_safe);
            if ($order_id_safe > 0) {
                $buttons[] = 
[['text' => "{$type_fa} #{$order_id_safe} - {$status_fa} - {$date_fa}", 'callback_data' => buildCallbackData('viewCustInvoiceOrder', ['id' => $order_id_safe])]];
            }
        }

        $pagination_row = buildPaginationRow('custInvoicePage', $offset, $limit, $total_orders);
    
        if (!empty($pagination_row)) {
            $buttons[] = $pagination_row;
        }
    }
    
    $buttons[] = [['text' => '🔙 بازگشت به منو اصلی', 
'callback_data' => buildCallbackData('mainMenu')]];
    $reply_markup_inline_only = ['inline_keyboard' => $buttons];

     if ($can_edit) {
         editMessage($chat_id, $message_id, $text, $reply_markup_inline_only);
     } else {
       
   $mainMenuKeyboard = getCustomerMainMenuKeyboard($user);
         $mainMenuKeyboard['inline_keyboard'] = $buttons;
         sendMessage($chat_id, $text, $mainMenuKeyboard, $platform);
     }
}

?>