<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

function showCategoryOrProducts(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data, array $user): void {

    $partner_user_id = $user['referred_by_user_id'] ?? null;

    $category_id_param = $params['id'] ?? null;
    $offset = (int)($params['offset'] ?? 0);
    $limit = 1;
    $can_edit = ($message_id !== null);
    $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null;
    $is_photo_message = $can_edit && isset($GLOBALS['update']['callback_query']['message']['photo']);

    if ($can_edit) {
        // برای اطمینان از عدم تداخل در ارسال عکس جدید، پیام قبلی را حذف می‌کنیم
    }

    $category_id = null;
    $show_all_products = false;

    if (is_numeric($category_id_param)) {
        $category_id = (int)$category_id_param;
    } elseif ($category_id_param === 'all') {
        $show_all_products = true;
    }

    if (!$show_all_products) {
        $subcategories = getActiveCategories($category_id);
        if (!empty($subcategories)) {
             if ($can_edit) {
                apiRequest('deleteMessage', ['chat_id' => $chat_id, 'message_id' => $message_id], $platform);
            }
            displaySubcategories($subcategories, $category_id, $chat_id, $platform, $user);
            return;
        } elseif ($category_id === null) {
            $show_all_products = true;
        }
    }

    $query_category_id = $show_all_products ? null : $category_id;
    
    $products = [];
    $total_products = 0;

    if ($partner_user_id !== null) {
        $total_products = countPartnerActiveProducts($partner_user_id, $query_category_id);
        if ($total_products > 0) {
            if ($offset < 0) $offset = max(0, $total_products - 1);
            if ($offset >= $total_products) $offset = 0;
            $products = getPartnerActiveProductsPaginated($partner_user_id, $query_category_id, $limit, $offset);
        }
    } else {
        $total_products = countActiveProducts($query_category_id);
         if ($total_products > 0) {
            if ($offset < 0) $offset = max(0, $total_products - 1);
            if ($offset >= $total_products) $offset = 0;
            $products = getActiveProducts($query_category_id, $limit, $offset);
        }
    }

    $base_inline_buttons = [];
    if ($category_id !== null && !$show_all_products) {
         $parent_cat = getCategoryById($category_id);
         $back_target_id = $parent_cat['parent_id'] ?? null;
         $base_inline_buttons[] = [['text' => '⬆️ بازگشت به دسته‌بندی‌ها', 'callback_data' => buildCallbackData('viewCat', ['id' => $back_target_id, 'offset' => 0])]];
    } elseif ($category_id === null && !$show_all_products && $total_products > 0) {
       $base_inline_buttons[] = [['text' => 'همه محصولات فروشگاه', 'callback_data' => buildCallbackData('viewCat', ['id' => 'all', 'offset' => 0])]];
    }

    $base_inline_buttons[] = [['text' => '🔙 بازگشت به منو اصلی', 'callback_data' => buildCallbackData('mainMenu')]];

    $mainMenuKeyboard = getCustomerMainMenuKeyboard($user);

    if ($total_products == 0) {
         $error_text = $partner_user_id ? "متاسفانه این همکار محصول فعالی در این دسته‌بندی ندارد." : "متاسفانه محصول فعالی در این دسته‌بندی یافت نشد.";
         if ($show_all_products) {
             $error_text = $partner_user_id ? "متاسفانه این همکار هیچ محصول فعالی برای فروش ندارد." : "متاسفانه هیچ محصول فعالی در فروشگاه یافت نشد.";
         }
        
         $reply_markup_with_main = $mainMenuKeyboard;
         $reply_markup_with_main['inline_keyboard'] = $base_inline_buttons;

         if ($can_edit) {
             apiRequest('deleteMessage', ['chat_id' => $chat_id, 'message_id' => $message_id], $platform);
         }
         sendMessage($chat_id, $error_text, $reply_markup_with_main, $platform);
         return;
    }

    if (empty($products)) {
         $error_text = "خطا در بارگذاری محصول.";
         $reply_markup_with_main = $mainMenuKeyboard;
         $reply_markup_with_main['inline_keyboard'] = $base_inline_buttons;
         
         if ($can_edit) {
             apiRequest('deleteMessage', ['chat_id' => $chat_id, 'message_id' => $message_id], $platform);
         }
         sendMessage($chat_id, $error_text, $reply_markup_with_main, $platform);
         return;
    }

    $product = $products[0];
    
    $caption = "";
    $action_buttons = [];
    
    if ($partner_user_id !== null) {
        list($caption, $action_buttons) = buildPartnerCustomerProductDisplay($product, $user_id, $session_data);
    } else {
        list($caption, $action_buttons) = buildProductDisplay($product, $user_id, $session_data);
    }
    
    // محدود کردن طول کپشن به ۱۰۲۴ کاراکتر (محدودیت تلگرام و بله برای عکس)
    $caption = str_replace(['*', '`'], '', $caption);
    if (mb_strlen($caption) > 1000) {
        $caption = mb_substr($caption, 0, 997) . '...';
    }
    
    $photo_url = $product['platform_photo_id'] ?? null;
    $relative_path = $product['image_path'] ?? null;
    $file_to_send = null;
    $local_file_path = null;

    if ($relative_path && defined('PRODUCT_IMAGE_STORAGE_PATH')) {
        $local_file_path = rtrim(PRODUCT_IMAGE_STORAGE_PATH, '/') . '/' . ltrim($relative_path, '/');
    }

    // اصلاح: استفاده دقیق از CURLFile با MimeType و FileName برای بله
   if ($platform === 'bale' && $local_file_path && file_exists($local_file_path)) {
        $real_path = realpath($local_file_path);
        
        // 🛠️ اصلاح: استفاده از MimeType مطمئن برای دور زدن مشکل mime_content_type
        $file_name = basename($real_path);
        $mime_type = 'image/' . pathinfo($file_name, PATHINFO_EXTENSION); // مثال: image/jpg
        if ($mime_type === 'image/tmp') $mime_type = 'image/jpeg'; // فال‌بک

        $file_to_send = new CURLFile($real_path, $mime_type, $file_name);
    } else {
        $file_to_send = $photo_url;
    }
    
    $final_inline_buttons = $action_buttons;
    
    if ($total_products > 1) {
        $nav_action = 'viewCat';
        $nav_id_param = $category_id_param ?? ($show_all_products ? 'all' : 'root');
        $prev_offset = ($offset - 1 < 0) ? $total_products - 1 : $offset - 1;
        $next_offset = ($offset + 1 >= $total_products) ? 0 : $offset + 1;
        $pagination_row = buildPaginationRowForProductView($nav_action, $offset, $total_products, ['id' => $nav_id_param], $prev_offset, $next_offset);
        if(!empty($pagination_row)) $final_inline_buttons[] = $pagination_row;
    }
    $final_inline_buttons = array_merge($final_inline_buttons, $base_inline_buttons);
    
    // ارسال پیام متنی منوی اصلی (برای اینکه کیبورد پایین بماند) - فقط اگر ادیت نیست یا اگر نیاز به تازه‌سازی منو هست
    if (!$can_edit) {
        sendMessage($chat_id, "لیست محصولات:", $mainMenuKeyboard, $platform);
    }

    $reply_markup_inline_only = ['inline_keyboard' => $final_inline_buttons];

    if (empty($file_to_send)) {
         $caption .= "\n\n⚠️ عکس محصول برای نمایش در دسترس نیست.";
         if ($is_photo_message && $can_edit) {
             apiRequest('deleteMessage', ['chat_id' => $chat_id, 'message_id' => $message_id], $platform);
             sendMessage($chat_id, $caption, $reply_markup_inline_only, $platform);
         } elseif ($can_edit) {
             editMessage($chat_id, $message_id, $caption, ['inline_keyboard' => $final_inline_buttons]);
         } else {
             sendMessage($chat_id, $caption, $reply_markup_inline_only, $platform);
         }
    } else {
        $media = ['type' => 'photo', 'media' => $file_to_send, 'caption' => $caption];
        
        // تصمیم‌گیری برای ارسال جدید یا ویرایش
        if (!$is_photo_message && $can_edit) {
            // قبلاً متن بوده، الان عکس است -> حذف قبلی و ارسال جدید
            apiRequest('deleteMessage', ['chat_id' => $chat_id, 'message_id' => $message_id], $platform);
            apiRequest('sendPhoto', [
                'chat_id' => $chat_id,
                'photo' => $file_to_send,
                'caption' => $caption,
                // حذف parse_mode برای جلوگیری از کرش
                'reply_markup' => $reply_markup_inline_only
            ], $platform);
        } elseif ($is_photo_message && $can_edit) {
             // قبلاً عکس بوده -> ویرایش مدیا (اگر بله پشتیبانی کند، وگرنه حذف و ارسال)
             
             $force_resend = ($platform === 'bale' && ($file_to_send instanceof CURLFile));
             
             if ($force_resend) {
                 apiRequest('deleteMessage', ['chat_id' => $chat_id, 'message_id' => $message_id], $platform);
                 apiRequest('sendPhoto', [
                    'chat_id' => $chat_id,
                    'photo' => $file_to_send,
                    'caption' => $caption,
                    // حذف parse_mode برای جلوگیری از کرش
                    'reply_markup' => $reply_markup_inline_only
                ], $platform);
             } else {
                 // تلاش برای ویرایش مدیا در تلگرام یا فایل آیدی در بله
                 $current_caption = $GLOBALS['update']['callback_query']['message']['caption'] ?? null;
                 $current_photo_id = $GLOBALS['update']['callback_query']['message']['photo'][0]['file_id'] ?? null;
                 
                 if ($current_photo_id != $file_to_send || $current_caption != $caption) {
                      apiRequest('editMessageMedia', ['chat_id' => $chat_id, 'message_id' => $message_id, 'media' => json_encode($media), 'reply_markup' => json_encode($reply_markup_inline_only)], $platform);
                 } else {
                      apiRequest('editMessageReplyMarkup', ['chat_id' => $chat_id, 'message_id' => $message_id, 'reply_markup' => json_encode($reply_markup_inline_only)], $platform);
                 }
             }
        } else {
             // پیام جدید
             apiRequest('sendPhoto', [
                'chat_id' => $chat_id,
                'photo' => $file_to_send,
                'caption' => $caption,
                'reply_markup' => $reply_markup_inline_only
            ], $platform);
        }
    }
}


function displaySubcategories(array $subcategories, ?int $category_id, int $chat_id, string $platform, array $user): void {
    $path_text = "دسته‌بندی اصلی";
    if ($category_id !== null) {
        $path_array = getCategoryPath($category_id);
        $path_names = array_map(function($p) { return htmlspecialchars($p['name'] ?? '?'); }, $path_array);
        $path_text = implode(" > ", $path_names);
    }
    
    // حذف Markdown از پیام
    $message_text_body = "شما در مسیر {$path_text} هستید.\nلطفا یک زیردسته را انتخاب کنید:";

    $inline_buttons = [];
    foreach ($subcategories as $subcat) {
       $cat_name = htmlspecialchars($subcat['name'] ?? 'نامشخص');
         $cat_id = $subcat['id'] ?? 0;
         if ($cat_id > 0) {
             $inline_buttons[] = [['text' => "📁 {$cat_name}", 'callback_data' => buildCallbackData('viewCat', ['id' => $cat_id, 'offset' => 0])]];
         }
    }
    
    if ($category_id !== null) {
        $parent_cat = getCategoryById($category_id);
        $back_target_id = $parent_cat['parent_id'] ?? null;
        $inline_buttons[] = [['text' => '⬆️ بازگشت به سطح قبل', 'callback_data' => buildCallbackData('viewCat', ['id' => $back_target_id, 'offset' => 0])]];
    } else {
         $inline_buttons[] = [['text' => 'همه محصولات فروشگاه', 'callback_data' => buildCallbackData('viewCat', ['id' => 'all', 'offset' => 0])]];
    }

    $inline_buttons[] = [['text' => '🔙 بازگشت به منو اصلی', 'callback_data' => buildCallbackData('mainMenu')]];
    
    $mainMenuKeyboard = getCustomerMainMenuKeyboard($user);
    $reply_markup_inline_only = ['inline_keyboard' => $inline_buttons];

    sendMessage($chat_id, $message_text_body, $mainMenuKeyboard, $platform);
    sendMessage($chat_id, "گزینه‌ها:", $reply_markup_inline_only, $platform);
}


function buildProductDisplay(array $product, int $user_id, array $session_data): array {
    $product_name = htmlspecialchars($product['name'] ?? 'نامشخص');
    $description = htmlspecialchars($product['description'] ?? '');
    
    // حذف Markdown از نام و توضیحات
    $product_name_safe = str_replace(['*', '_', '`', '['], '', $product_name);
    $description_safe = str_replace(['*', '_', '`', '['], '', $description);
    
    $unit = $product['unit'] ?? '';
    $stock = $product['stock'] ?? null;
    $product_id = $product['id'] ?? 0;
    $product_type = $product['type'] ?? 'simple';
    $pricing = $product['pricing'] ?? ['price' => '0.00', 'on_sale' => false, 'base_price' => '0.00'];

    // حذف Markdown از قیمت
    $price_text = number_format($pricing['price']) . " تومان";
    if($pricing['on_sale'] && bccomp((string)$pricing['base_price'], (string)$pricing['price'], 2) > 0){
        $price_text = "~" . number_format($pricing['base_price']) . "~ " . $price_text;
    }
    
    $stock_text = '';
    if ($stock === null) {
        $stock_text = '✅ موجود';
    } elseif (bccomp((string)$stock, '0', 1) > 0) {
        $stock_formatted = number_format((float)$stock, (strpos($stock, '.') !== false) ? 1 : 0, '.', '');
        $stock_text = "موجودی: {$stock_formatted} {$unit}";
    } else {
        $stock_text = "❌ ناموجود";
    }
   

    $caption = "{$product_name_safe}\n\n{$description_safe}\n\n"; // حذف *
    $action_buttons = [];
    
    if ($product_type === 'simple') {
        $caption .= "قیمت: {$price_text} / {$unit}\n{$stock_text}";
        if ($product_id > 0 && ($stock === null || bccomp((string)$stock, '0', 1) > 0)) {
            $action_buttons[] = ['text' => '➕ افزودن به سبد خرید', 'callback_data' => buildCallbackData('addToCart', ['id' => $product_id])];
        }
    } else {
        $attributes = getSelectedValuesGroupedByAttribute($product_id);
        if (empty($attributes)) {
            $caption .= "این محصول متغیر در حال حاضر قابل فروش نیست (ویژگی‌ها تنظیم نشده‌اند).";
        } else {
            $session_data['product_variation_selection'] = [
                'product_id' => $product_id,
                'attributes' => $attributes,
                'current_attr_index' => 0,
                'selected_values' => []
            ];
            updateUserField($user_id, 'session', json_encode($session_data));
            
            $first_attribute = $attributes[0];
            $caption .= "لطفا گزینه‌های محصول را انتخاب کنید:\n\n";
            $caption .= "انتخاب {$first_attribute['attribute_name']}:"; // حذف *
            
            $row = [];
            foreach ($first_attribute['values'] as $value) {
                $row[] = ['text' => $value['value'], 'callback_data' => buildCallbackData('selectAttributeValue', ['val_id' => $value['id']])];
                if (count($row) == 2) {
                    $action_buttons[] = $row;
                    $row = [];
                }
            }
            if (!empty($row)) $action_buttons[] = $row;
        }
    }
    
    return [$caption, !empty($action_buttons) ? $action_buttons : [] ];
}


function buildPartnerCustomerProductDisplay(array $product, int $user_id, array $session_data): array {
    $product_name = htmlspecialchars($product['name'] ?? 'نامشخص');
    $description = htmlspecialchars($product['description'] ?? '');
    
    // حذف Markdown از نام و توضیحات
    $product_name_safe = str_replace(['*', '_', '`', '['], '', $product_name);
    $description_safe = str_replace(['*', '_', '`', '['], '', $description);
    
    $unit = $product['unit'] ?? '';
    $stock = $product['stock'] ?? null;
    $product_id = $product['id'] ?? 0;
    $product_type = $product['type'] ?? 'simple';
    
    $pricing = $product['pricing'] ?? ['price' => '0.00', 'on_sale' => false, 'base_price' => '0.00'];
    $partner_profit = $product['extra_price'] ?? '0.00';

    $final_price = bcadd($pricing['price'], $partner_profit, 2);
    // حذف Markdown از قیمت
    $price_text = number_format($final_price) . " تومان";

    if($pricing['on_sale'] && bccomp((string)$pricing['base_price'], (string)$pricing['price'], 2) > 0){
         $original_final_price = bcadd($pricing['base_price'], $partner_profit, 2);
        $price_text = "~" . number_format($original_final_price) . "~ " . $price_text;
    }
    
    $stock_text = '';
    if ($stock === null) {
        $stock_text = '✅ موجود';
    } elseif (bccomp((string)$stock, '0', 1) > 0) {
        $stock_formatted = number_format((float)$stock, (strpos($stock, '.') !== false) ? 1 : 0, '.', '');
        $stock_text = "موجودی: {$stock_formatted} {$unit}";
    } else {
        $stock_text = "❌ ناموجود";
    }

    $caption = "{$product_name_safe}\n\n{$description_safe}\n\n"; // حذف *
    $action_buttons = [];
    
    if ($product_type === 'simple') {
        $caption .= "قیمت: {$price_text} / {$unit}\n{$stock_text}";
        if ($product_id > 0 && ($stock === null || bccomp((string)$stock, '0', 1) > 0)) {
            $action_buttons[] = ['text' => '➕ افزودن به سبد خرید', 'callback_data' => buildCallbackData('addToCart', ['id' => $product_id])];
        }
    } else {
        $attributes = getSelectedValuesGroupedByAttribute($product_id);
        if (empty($attributes)) {
            $caption .= "این محصول متغیر در حال حاضر قابل فروش نیست.";
        } else {
            $session_data['product_variation_selection'] = [
                'product_id' => $product_id,
                'attributes' => $attributes,
                'current_attr_index' => 0,
                'selected_values' => []
            ];
            updateUserField($user_id, 'session', json_encode($session_data));
           
            $first_attribute = $attributes[0];
            $caption .= "لطفا گزینه‌های محصول را انتخاب کنید:\n\n";
            $caption .= "انتخاب {$first_attribute['attribute_name']}:"; // حذف *
            
            $row = [];
            foreach ($first_attribute['values'] as $value) {
                $row[] = ['text' => $value['value'], 'callback_data' => buildCallbackData('selectAttributeValue', ['val_id' => $value['id']])];
                if (count($row) == 2) {
                    $action_buttons[] = $row;
                    $row = [];
                }
            }
            if (!empty($row)) $action_buttons[] = $row;
        }
    }
    
    return [$caption, !empty($action_buttons) ? $action_buttons : [] ];
}


function buildPaginationRowForProductView(string $action, int $offset, int $total, array $extra_params, int $prev_offset, int $next_offset): array {
    $pagination_row = [];
    if ($total > 1) {
       
        $current_page = $offset + 1;

        $prev_params = array_merge($extra_params, ['offset' => $prev_offset]);
        $pagination_row[] = ['text' => '⬅️ قبلی', 'callback_data' => buildCallbackData($action, $prev_params)];

        $pagination_row[] = ['text' => "{$current_page}/{$total}", 'callback_data' => 'noop'];

        $next_params = array_merge($extra_params, ['offset' => $next_offset]);
        $pagination_row[] = ['text' => 'بعدی ➡️', 'callback_data' => buildCallbackData($action, $next_params)];
    }
    return $pagination_row;
}
?>