<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

function showPayoutMenu(int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data, array $user): void {
    $can_edit = ($message_id !== null);

    $pending_request = getPendingPayoutRequest($user_id);
    if ($pending_request) {
        $text = "⚠️ *شما یک درخواست تسویه در حال انتظار دارید.*\n\n";
        $text .= "مبلغ: `" . number_format($pending_request['amount']) . "` تومان\n";
        $text .= "تاریخ: " . to_jalali_datetime($pending_request['created_at']) . "\n\n";
        $text .= "تا زمان تکمیل این درخواست توسط مدیر، امکان ثبت درخواست جدید وجود ندارد.";
        
        $buttons = [[['text' => '🔙 بازگشت به منو اصلی', 'callback_data' => buildCallbackData('mainMenu')]]];
        $reply_markup = ['inline_keyboard' => $buttons];

        if ($can_edit) {
            editMessage($chat_id, $message_id, $text, $reply_markup);
        } else {
            sendMessage($chat_id, $text, $reply_markup, $platform);
        }
        return;
    }

    $total_unpaid_profit = getUnpaidPartnerProfit($user_id, false); 
    $available_profit = getUnpaidPartnerProfit($user_id, true); 
    
    $text = "💰 *نقد کردن درآمد*\n\n";
    $text .= "کل سود در انتظار شما (از سفارشات اخیر): \n";
    $text .= "## `" . number_format($total_unpaid_profit) . "` تومان\n\n";
    $text .= "موجودی قابل تسویه (سفارشات قدیمی‌تر از ۷ روز): \n";
    $text .= "## `" . number_format($available_profit) . "` تومان\n\n";
    
    $buttons = [];
    $min_payout_amount = 100; 

    if (bccomp($available_profit, (string)$min_payout_amount, BC_SCALE) >= 0) {
        $user_cards = getUserCards($user_id);
        if (empty($user_cards)) {
            $text .= "⚠️ برای تسویه حساب، ابتدا باید حداقل یک کارت بانکی (به نام خودتان) را در بخش «💳 مدیریت کارت‌ها» ثبت کنید.";
        } else {
            $text .= "لطفا کارت بانکی مورد نظر خود برای واریز را انتخاب کنید:";
            foreach ($user_cards as $card) {
                $buttons[] = [['text' => $card['card_number_masked'], 'callback_data' => buildCallbackData('partnerSelectPayoutCard', ['cid' => $card['id']])]];
            }
        }
    } else {
        $text .= "حداقل مبلغ قابل تسویه `" . number_format($min_payout_amount) . "` تومان است. موجودی شما در حال حاضر کافی نیست.";
    }

    $buttons[] = [['text' => '🔙 بازگشت به منو اصلی', 'callback_data' => 
buildCallbackData('mainMenu')]];
    $reply_markup = ['inline_keyboard' => $buttons];

    if ($can_edit) {
        editMessage($chat_id, $message_id, $text, $reply_markup);
    } else {
        sendMessage($chat_id, $text, $reply_markup, 
$platform);
    }
}

function confirmPayoutRequest(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {
    $card_id = (int)($params['cid'] ?? 0);
    $can_edit = ($message_id !== null);

    if ($card_id <= 0 || !$can_edit) {
        showPayoutMenu($chat_id, $message_id, $user_id, $platform, $session_data, $GLOBALS['user']);
        return;
    }

    $card = getDecryptedUserCardById($card_id, $user_id);
    if (!$card) {
        editMessage($chat_id, $message_id, "خطا: کارت بانکی انتخاب شده یافت نشد.", null);
        showPayoutMenu($chat_id, null, $user_id, $platform, $session_data, $GLOBALS['user']);
        return;
    }
    $card_masked = maskCardNumber($card);

    $available_profit = getUnpaidPartnerProfit($user_id, true);
    $min_payout_amount = 100; 
    
    if (bccomp($available_profit, 
(string)$min_payout_amount, BC_SCALE) < 0) {
        editMessage($chat_id, $message_id, "خطا: موجودی شما برای تسویه کافی نیست.", null);
        showPayoutMenu($chat_id, null, $user_id, $platform, $session_data, $GLOBALS['user']);
        return;
    }
    
    if (getPendingPayoutRequest($user_id)) {
        editMessage($chat_id, $message_id, "خطا: شما یک درخواست تسویه در حال انتظار دارید.", null);
        showPayoutMenu($chat_id, 
null, $user_id, $platform, $session_data, $GLOBALS['user']);
        return;
    }

    $session_data['payout_data'] = [
        'amount' => $available_profit,
        'card_id' => $card_id,
        'card_masked' => $card_masked
    ];
    
updateUserField($user_id, 'session', json_encode($session_data));

    $text = "⚠️ *تایید نهایی درخواست تسویه*\n\n";
    $text .= "شما در حال ثبت درخواست تسویه به مبلغ `" . number_format($available_profit) . "` تومان هستید.\n";
    $text .= "مبلغ به کارت زیر واریز خواهد شد:\n";
    $text .= "`{$card_masked}`\n\n";
    $text .= "آیا تایید می‌کنید؟ (پس از تایید، این مبلغ از موجودی قابل برداشت شما کسر شده و در انتظار پرداخت مدیر قرار می‌گیرد)";

    $buttons = [
        [['text' => '✅ بله، ثبت درخواست تسویه', 'callback_data' => buildCallbackData('partnerConfirmPayout')]],
        [['text' => '❌ انصراف (بازگشت)', 'callback_data' => buildCallbackData('partnerPayout')]]
    ];
    
    editMessage($chat_id, $message_id, $text, ['inline_keyboard' => $buttons]);
}

function handleCreatePayoutRequest(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, 
array $session_data, array $user): void {
    $payout_data = $session_data['payout_data'] ?? null;
    $can_edit = ($message_id !== null);
    $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null;

    if (!$payout_data || empty($payout_data['amount']) || empty($payout_data['card_id'])) {
         if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: اطلاعات تسویه یافت نشد.', 'show_alert' => true], $platform);
        if ($can_edit) editMessage($chat_id, $message_id, "خطا: اطلاعات تسویه منقضی شده است.", null);
        showPayoutMenu($chat_id, null, $user_id, $platform, $session_data, $user);
        return;
    }
    
    if (getPendingPayoutRequest($user_id)) {
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: شما یک درخواست تسویه در حال انتظار دارید.', 'show_alert' => true], $platform);
        if ($can_edit) editMessage($chat_id, $message_id, "خطا: شما یک درخواست تسویه در حال انتظار دارید.", null);
        showPayoutMenu($chat_id, 
null, $user_id, $platform, $session_data, $user);
        return;
    }

    $available_profit = getUnpaidPartnerProfit($user_id, true);
    if (bccomp($available_profit, $payout_data['amount'], 
BC_SCALE) != 0) {
        if ($callback_query_id) 
apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: موجودی شما تغییر کرده است. لطفا مجددا تلاش کنید.', 'show_alert' => true], $platform);
        if ($can_edit) editMessage($chat_id, $message_id, "خطا: موجودی شما تغییر کرده است. لطفا مجددا تلاش کنید.", null);
        showPayoutMenu($chat_id, null, $user_id, $platform, $session_data, $user);
        return;
    }

    $payout_request_id = createPayoutRequest($user_id, $payout_data['amount'], $payout_data['card_id']);

    if ($payout_request_id > 0) {
        $text = "✅ درخواست تسویه شما به مبلغ `" . number_format($payout_data['amount']) . "` تومان با موفقیت ثبت شد و در انتظار تایید مدیر قرار گرفت.";
        
        updateUserField($user_id, 'session', json_encode(['state' => 'idle']));
        if ($can_edit) editMessage($chat_id, $message_id, $text, null);
        
        $request = getPayoutRequestDetails($payout_request_id);
        if 
($request) {
            $admin_text = "🛎 *درخواست تسویه حساب جدید* (شماره `{$request['id']}`)\n\n" .
                          "👤 همکار: *{$request['first_name']}*\n" .
                          "📞 تماس: `{$request['phone_number']}`\n" .
                          "💰 *مبلغ:* `" . number_format($request['amount']) . "` تومان\n" .
                          "🏦 *کارت:* `{$request['card_number_masked']}`\n\n" .
                          "لطفا برای پردازش به پنل مراجعه کنید.";

            notifyAdmins($admin_text);
        }
        
    } else {
        $text = "❌ 
خطایی در ثبت درخواست تسویه در دیتابیس رخ داد. لطفا مجددا تلاش کنید.";
        if ($can_edit) editMessage($chat_id, $message_id, $text, null);
    }

    showCustomerMainMenu($chat_id, $user_id, $platform, $user);
}

?>