<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

function showPartnerShopMenu(int $chat_id, int $user_id, string $platform, array $user, ?int $message_id = null): void {
    
    if (($user['is_admin'] ?? false) == true || $user['referred_by_user_id'] !== null) {
        sendMessage($chat_id, "خطا: این بخش فقط مخصوص همکاران است.", null, $platform);
        if ($message_id) {
            apiRequest('deleteMessage', ['chat_id' => $chat_id, 'message_id' => $message_id], $platform);
        }
        showCustomerMainMenu($chat_id, $user_id, $platform, $user);
        return;
    }

    $referral_code = generateAndSetReferralCode($user_id);

    if (empty($referral_code)) {
        sendMessage($chat_id, "خطا در ایجاد کد معرف شما. لطفا با پشتیبانی تماس بگیرید.", null, $platform);
        if ($message_id) {
            apiRequest('deleteMessage', ['chat_id' => $chat_id, 'message_id' => $message_id], $platform);
        }
        showCustomerMainMenu($chat_id, $user_id, $platform, $user);
        return;
    }

    $bot_username = ($platform === 'bale') ? BALE_BOT_USERNAME : TELEGRAM_BOT_USERNAME; 
    $referral_link = "https://{$platform}.me/{$bot_username}?start={$referral_code}";
    
    if ($platform === 'bale') {
         $referral_link = "https://ble.ir/{$bot_username}?start={$referral_code}";
    } else {
         $referral_link = "https://t.me/{$bot_username}?start={$referral_code}";
    }


    $text = "🛍️ *فروشگاه من*\n\n";
    $text .= "این پنل مخصوص شما (همکار) است. شما می‌توانید با استفاده از لینک زیر، مشتریان خود را دعوت کنید:\n\n";
    $text .= "`{$referral_link}`\n\n";
    $text .= "(با کلیک روی لینک بالا، کپی می‌شود)\n\n";
    $text .= "مشتریان شما فقط محصولاتی را می‌بینند که شما در بخش 'مدیریت محصولات' فعال کرده و برای آن‌ها سود تعیین کرده باشید.";

    $buttons = [
        [['text' => '🗂️ مدیریت محصولات فروشگاه', 'callback_data' => buildCallbackData('managePartnerProds', ['id' => null, 'offset' => 0])]],
        [['text' => '🔙 بازگشت به منو اصلی', 'callback_data' => buildCallbackData('mainMenu')]]
    ];
    
    $reply_markup = ['inline_keyboard' => $buttons];

    if ($message_id) {
        editMessage($chat_id, $message_id, $text, $reply_markup);
    } else {
        sendMessage($chat_id, $text, $reply_markup, $platform);
    }
}

?>