<?php
// src/Modules/Customer/Referral/ViewPartnerCustomerOrder.php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

function showPartnerCustomerOrderDetails(array $params, int $chat_id, ?int $message_id, int $user_id, string $platform, array $user): void {
    $order_id = (int)($params['id'] ?? 0);
    $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null;
    $can_edit = ($message_id !== null);

    if ($order_id <= 0) {
        if ($callback_query_id) apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: شماره سفارش نامعتبر.', 'show_alert' => true], $platform);
        showPartnerOrderList(['offset' => 0, 'type' => 'customer'], $chat_id, $message_id, $user_id, $platform, $user);
        return;
    }

    $order = getOrderDetails($order_id);

    if ($order && isset($order['partner_user_id']) && $order['partner_user_id'] == $user_id) {
        $message_body = buildPartnerCustomerOrderDetailsText($order);
        $buttons = [];
        
        // --- FIX: Ensure the back button points to the correct partner order list (customer type) ---
        $buttons[] = [['text' => '🔙 بازگشت به لیست سفارشات مشتریان', 'callback_data' => buildCallbackData('listCustomerOrders', ['offset' => 0, 'type' => 'customer'])]];
        // --- END FIX ---
        
        $reply_markup = ['inline_keyboard' => $buttons];

         if ($can_edit) {
             editMessage($chat_id, $message_id, $message_body, $reply_markup);
         } else {
             sendMessage($chat_id, "جزئیات سفارش:", getCustomerMainMenuKeyboard($user), $platform);
             sendMessage($chat_id, $message_body, $reply_markup, $platform);
           }
    } else {
        if ($callback_query_id) {
           apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: سفارش یافت نشد.', 'show_alert' => true], $platform);
           }
        
        if ($can_edit) {
            apiRequest('deleteMessage', ['chat_id' => $chat_id, 'message_id' => $message_id], $platform);
        }
        showPartnerOrderList(['offset' => 0, 'type' => 'customer'], $chat_id, null, $user_id, $platform, $user);
    }
}

?>