<?php

// Prevent direct script access
if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

/**
 * Handles callback queries related to birthdate selection.
 */
function handleBirthdateCallback(string $action, array $params, string $current_status, int $chat_id, ?int $message_id, int $user_id, string $platform, array $session_data): void {

    $can_edit = ($message_id !== null);
    $callback_query_id = $GLOBALS['update']['callback_query']['id'] ?? null; 

    // --- Year Selection --- //
    if ($action === 'selectBirthYear' && $current_status === 'awaiting_birth_year') {
        $year = (int)($params['y'] ?? 0);
        $current_jdate_year = (int)jdate('Y', time(), '', null, 'en'); 
        if ($year > 1300 && $year <= ($current_jdate_year - 5)) { 
            // Store year temporarily in session
            $session_data['birth_date_year'] = $year;
            updateUserField($user_id, 'session', json_encode($session_data)); 
            updateUserStatus($user_id, 'awaiting_birth_month'); 
            
            $keyboard_markup = buildBirthMonthKeyboard('selectBirth', $year); 
            $text = "سال `{$year}` انتخاب شد. لطفا *ماه* تولد خود را انتخاب کنید:";
            if ($can_edit) {
               editMessage($chat_id, $message_id, $text, $keyboard_markup); 
            } else {
                sendMessage($chat_id, $text, $keyboard_markup, $platform); 
            }
        } else {
            if ($callback_query_id) { apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'سال انتخاب شده نامعتبر است.', 'show_alert' => true], $platform); }
        }
    } 
    // --- START FIX: Handle Year Pagination --- //
    elseif ($action === 'selectBirthYearPage' && $current_status === 'awaiting_birth_year') {
        $offset = (int)($params['offset'] ?? 0);
        $keyboard_markup = buildBirthYearKeyboard('selectBirth', $offset); 
        $text = "لطفا *سال* تولد خود را (۴ رقمی شمسی) انتخاب کنید:";
        if ($can_edit) {
            editMessage($chat_id, $message_id, $text, $keyboard_markup); 
        } else {
            sendMessage($chat_id, $text, $keyboard_markup, $platform); 
        }
    } 
    // --- END FIX --- //
    // --- Back To Year Selection --- //
    elseif ($action === 'backToBirthYear' && ($current_status === 'awaiting_birth_month' || $current_status === 'awaiting_birth_year')) {
         updateUserStatus($user_id, 'awaiting_birth_year'); 
         $keyboard_markup = buildBirthYearKeyboard('selectBirth'); 
         $text = "لطفا *سال* تولد خود را (۴ رقمی شمسی) انتخاب کنید:";
         if ($can_edit) {
            editMessage($chat_id, $message_id, $text, $keyboard_markup); 
         } else {
             // Should ideally not happen if started with inline keyboard
             sendMessage($chat_id, $text, $keyboard_markup, $platform); 
         }
    } 
    // --- Month Selection --- //
    elseif ($action === 'selectBirthMonth' && $current_status === 'awaiting_birth_month') {
        $year = (int)($params['y'] ?? ($session_data['birth_date_year'] ?? 0));
        $month = (int)($params['m'] ?? 0);
        if ($year > 1300 && $month >= 1 && $month <= 12) {
            $session_data['birth_date_month'] = $month;
            updateUserField($user_id, 'session', json_encode($session_data)); 
            updateUserStatus($user_id, 'awaiting_birth_day'); 
            
            $keyboard_markup = buildBirthDayKeyboard('selectBirth', $year, $month); 
            $text = "ماه `{$month}` انتخاب شد. لطفا *روز* تولد خود را انتخاب کنید:";
            if ($can_edit) {
               editMessage($chat_id, $message_id, $text, $keyboard_markup); 
            } else {
                sendMessage($chat_id, $text, $keyboard_markup, $platform); 
            }
        } else {
            if ($callback_query_id) { apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا در اطلاعات ماه یا سال.', 'show_alert' => true], $platform); }
            // Go back to year selection if year is missing
            if ($year <= 1300) {
                 handleBirthdateCallback('backToBirthYear', [], 'awaiting_birth_month', $chat_id, $message_id, $user_id, $platform, $session_data);
            }
        }
    } 
    // --- Back To Month Selection --- //
    elseif ($action === 'backToBirthMonth' && ($current_status === 'awaiting_birth_day' || $current_status === 'awaiting_birth_month')) {
         $year = (int)($params['y'] ?? ($session_data['birth_date_year'] ?? 0));
         if ($year > 1300) {
             updateUserStatus($user_id, 'awaiting_birth_month'); 
             $keyboard_markup = buildBirthMonthKeyboard('selectBirth', $year); 
             $text = "سال `{$year}` انتخاب شد. لطفا *ماه* تولد خود را انتخاب کنید:";
             if ($can_edit) {
                 editMessage($chat_id, $message_id, $text, $keyboard_markup); 
             } else {
                 sendMessage($chat_id, $text, $keyboard_markup, $platform); 
             }
         } else {
            // If year is invalid, go back to year selection
              handleBirthdateCallback('backToBirthYear', [], 'awaiting_birth_month', $chat_id, $message_id, $user_id, $platform, $session_data);
         }
    }
    // --- Day Selection --- //
    elseif ($action === 'selectBirthDay' && $current_status === 'awaiting_birth_day') {
        $year = (int)($params['y'] ?? ($session_data['birth_date_year'] ?? 0));
        $month = (int)($params['m'] ?? ($session_data['birth_date_month'] ?? 0));
        $day = (int)($params['d'] ?? 0);

        // Basic day validation
        $is_leap = in_array($year % 33, [1, 5, 9, 13, 17, 22, 26, 30]);
        $days_in_month = ($month <= 6) ? 31 : (($month <= 11) ? 30 : ($is_leap ? 30 : 29)); 

        if ($year > 1300 && $month > 0 && $day > 0 && $day <= $days_in_month) {
            $birth_date_str = sprintf('%04d/%02d/%02d', $year, $month, $day); 
            updateUserField($user_id, 'birth_date', $birth_date_str); 
            updateUserStatus($user_id, 'awaiting_selfie'); 

            // Clean up temporary session data
            unset($session_data['birth_date_year'], $session_data['birth_date_month']);
            updateUserField($user_id, 'session', json_encode($session_data)); 

            // Delete the date selection message
            if ($can_edit) {
                 apiRequest('deleteMessage', ['chat_id' => $chat_id, 'message_id' => $message_id], $platform); 
            }
            
            sendMessage($chat_id, "✅ تاریخ تولد شما `{$birth_date_str}` ثبت شد.", null, $platform); 
            
            // Send contract and ask for selfie
            $caption = "عالی! حالا لطفاً فایل قرارداد زیر را دانلود و چاپ کنید. پس از امضا و اثر انگشت، یک عکس واضح از *برگه تکمیل شده* ارسال نمایید.";
            // Send contract document
            if (defined('CONTRACT_PDF_PATH') && file_exists(CONTRACT_PDF_PATH)) {
                 if (!sendDocument($chat_id, CONTRACT_PDF_PATH, $caption, $platform)) { 
                      // Log error if sending document fails
                       if(defined('ERROR_LOG_PATH')) file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - Error: Failed to send contract PDF to user {$user_id}.\n", FILE_APPEND);
                       // Notify admin
                       $admin_error = "⚠️ *خطای سیستمی:* ارسال فایل قرارداد برای کاربر `{$user_id}` با شکست مواجه شد.";
                       notifyAdmins($admin_error);
                       sendMessage($chat_id, "خطایی در ارسال فایل قرارداد رخ داد. لطفا با پشتیبانی تماس بگیرید.", null, $platform); 
                 }
            } else {
               if(defined('ERROR_LOG_PATH')) file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - Error: Contract PDF file not found at " . (CONTRACT_PDF_PATH ?? 'N/A') . "\n", FILE_APPEND);
                 sendMessage($chat_id, $caption . "\n\n(خطا: فایل قرارداد یافت نشد. لطفا با پشتیبانی تماس بگیرید.)", null, $platform); 
            }
        } else {
             if ($callback_query_id) { apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'روز انتخاب شده نامعتبر است.', 'show_alert' => true], $platform); }
        }
    }
    else {
        // Handle callbacks arriving in the wrong status
        if ($callback_query_id) { apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'لطفا مراحل را به ترتیب دنبال کنید.', 'show_alert' => false], $platform); }
    }
}

?>