<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

function handleFullNameInput(?string $message_text, int $chat_id, int $user_id, string $platform): void {
    global $user; 

    if ($message_text === null || trim($message_text) === '') {
         sendMessage($chat_id, "لطفا نام و نام خانوادگی خود را (به فارسی) وارد کنید.", null, $platform); 
         return;
    }
    
    
    $full_name = strip_tags(trim($message_text));
    
    
    
    if (strlen($full_name) < 5 || !preg_match('/[ ]/', $full_name)) {
        sendMessage($chat_id, "❌ لطفا نام و نام خانوادگی خود را به صورت کامل (همراه با فاصله) وارد کنید.", null, $platform);
        return;
    }
    
    
    updateUserField($user_id, 'first_name', $full_name); 
    
    if (isset($user['referred_by_user_id']) && $user['referred_by_user_id'] !== null) {
        
        updateUserStatus($user_id, 'awaiting_verification_payment'); 
        sendMessage($chat_id, "✅ نام شما ثبت شد.\n\n*مرحله بعد:* برای تکمیل ثبت نام، لطفا هزینه احراز هویت را پرداخت کنید.", ['remove_keyboard' => true], $platform); 
        
        sendVerificationPaymentRequest($chat_id, $user_id, $platform, $user['phone_number'] ?? '');
        
    } else {
        
        updateUserStatus($user_id, 'awaiting_national_id_photo'); 
        sendMessage($chat_id, "✅ نام شما ثبت شد.\n\n*مرحله بعد:* لطفاً یک عکس واضح از *چهره خودتان در کنار کارت ملی* ارسال کنید (هر دو باید واضح باشند).", null, $platform);
    }
}

?>