<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

function handleNationalIdCodeInput(?string $message_text, int $chat_id, int $user_id, string $platform, string $user_phone): void {
    global $user;

    if ($message_text === null) {
         sendMessage($chat_id, "لطفا کد ملی خود را (۱۰ رقمی و بدون خط تیره) وارد کنید.", null, $platform); 
         return;
    }

    $national_code = convertPersianToEnglishDigits($message_text); 

    if (validateNationalIdFormat($national_code)) { 
        
        $existing_user_with_nid = getUserByNationalId($national_code);
        if ($existing_user_with_nid && $existing_user_with_nid['id'] != $user_id) {
            sendMessage($chat_id, "❌ این کد ملی قبلا توسط حساب دیگری استفاده شده است. اگر فکر می‌کنید خطایی رخ داده، با پشتیبانی تماس بگیرید.", null, $platform);
            return;
        }

        sendMessage($chat_id, "⏳ در حال استعلام تطابق کد ملی و شماره موبایل شما از سامانه ...", null, $platform); 
        
        $match = checkShahkar($user_phone, $national_code); 

        if ($match === true) {
            updateUserField($user_id, 'national_id_code', $national_code); 
            
            if (isset($user['referred_by_user_id']) && $user['referred_by_user_id'] !== null) {
                
                updateUserStatus($user_id, 'verified'); 
                sendMessage($chat_id, "✅ کد ملی شما با شماره موبایل تطابق دارد و تایید شد.\n\nثبت نام شما به عنوان مشتری کامل شد. اکنون می‌توانید از فروشگاه خرید کنید.", ['remove_keyboard' => true], $platform); 
                
                showCustomerMainMenu($chat_id, $user_id, $platform, $user);
            } else {
                
                updateUserStatus($user_id, 'awaiting_verification_payment'); 
                sendMessage($chat_id, "✅ کد ملی شما با شماره موبایل تطابق دارد و تایید شد.", null, $platform); 
                
                
                sendVerificationPaymentRequest($chat_id, $user_id, $platform, $user_phone);
            }

        } elseif ($match === false) {
            sendMessage($chat_id, "❌ کد ملی وارد شده با شماره موبایل ثبت شده شما تطابق ندارد.\n\nلطفا کد ملی صحیح مربوط به مالک سیم‌کارت را وارد کنید یا در صورت اطمینان از صحت اطلاعات با پشتیبانی تماس بگیرید.", null, $platform); 
            
            $user_name = $user['first_name'] ?? 'ناشناس';
            $admin_message = "🔔 *اطلاع: ورود اطلاعات اشتباه*\n\n" .
                           "کاربر: *{$user_name}*\n" .
                           "شماره تماس: `{$user_phone}`\n" .
                           "کد ملی وارد شده: `{$national_code}`\n" .
                           "نتیجه: *عدم تطابق شاهکار*";
            notifyAdmins($admin_message);

        } else { 
             sendMessage($chat_id, "❌ خطایی در استعلام از سامانه شاهکار رخ داد. لطفا چند دقیقه دیگر مجددا تلاش کنید یا با پشتیبانی تماس بگیرید.", null, $platform); 
        }
    } else {
        sendMessage($chat_id, "❌ فرمت کد ملی صحیح نیست. لطفا یک کد ملی ۱۰ رقمی (بدون خط تیره یا فاصله) وارد کنید.", null, $platform); 
    }
}

?>