<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

function handleNationalIdPhotoInput(array $message, int $chat_id, int $user_id, string $platform): void {
    
    if (isset($message['photo'])) {
        $photo_array = $message['photo'];
        $source_file_id = end($photo_array)['file_id']; 

        sendMessage($chat_id, "⏳ در حال پردازش و ذخیره‌سازی امن تصویر شما...", null, $platform); 

        $file_content = downloadFileContent($source_file_id, $platform);

        if ($file_content) {
            $encrypted_data = encryptFileData($file_content);
            unset($file_content);

            if ($encrypted_data) {
                if (updateUserField($user_id, 'national_id_data', $encrypted_data)) {
                    
                    global $user;
                    
                    if (!empty($user['selfie_data'])) {
                        
                        updateUserStatus($user_id, 'awaiting_admin_selfie_approval');
                        sendMessage($chat_id, "📸 تصویر (چهره و کارت ملی) شما به‌روزرسانی شد و مجدداً برای بررسی ارسال گردید.", null, $platform);

                        $request_id = createPendingAdminRequest($user_id, 'selfie');
                        if ($request_id > 0) {
                            $GLOBALS['current_pending_request_id'] = $request_id; 
                            
                            $admin_message = "🛎 *درخواست تایید (اصلاح شده)*\n\n" .
                                         "کاربر: {$user['first_name']} (ID: `{$user_id}`)\n" .
                                         "فایل (چهره و کارت ملی) خود را مجدداً ارسال کرد. لطفا هر دو فایل را بررسی کنید.";
                            notifyAdmins($admin_message);
                        }

                    } else {
                        updateUserStatus($user_id, 'awaiting_national_id_code'); 
                        sendMessage($chat_id, "📸 تصویر شما دریافت و به صورت امن ذخیره شد.\n\n*مرحله بعد:* اکنون لطفا کد ملی خود را (۱۰ رقمی و بدون خط تیره) وارد کنید.", null, $platform); 
                    }

                } else {
                    sendMessage($chat_id, "❌ خطا در ذخیره‌سازی داده‌های تصویر شما در دیتابیس. لطفا دوباره ارسال کنید.", null, $platform);
                    if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - NID DB save failed for user {$user_id}.\n", FILE_APPEND); }
                }
            } else {
                sendMessage($chat_id, "❌ خطا در رمزنگاری تصویر شما. لطفا دوباره ارسال کنید.", null, $platform);
                if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - NID encryption failed for user {$user_id}.\n", FILE_APPEND); }
            }
        } else {
             sendMessage($chat_id, "❌ خطا در دانلود تصویر شما. (کد: 404)\n\nفایل ارسالی شما نامعتبر است یا منقضی شده است. لطفا یک عکس واضح و جدید (نه فوروارد شده) از چهره و کارت ملی خود ارسال کنید.", null, $platform); 
        }
    } else {
        sendMessage($chat_id, "لطفا فقط یک *عکس* (و نه فایل) از چهره و کارت ملی خود ارسال کنید.", null, $platform); 
    }
}
?>