<?php
if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}
define('OTP_EXPIRY_SECONDS', 300); 
define('OTP_RESEND_COOLDOWN_SECONDS', 60);
function handleOtpInput(?string $message_text, int $chat_id, int $user_id, string $platform, ?string $expected_otp, int $otp_timestamp): void {
    global $user;

    if ($otp_timestamp === 0 || empty($expected_otp)) {
        sendMessage($chat_id, "❌ کد تایید یا زمان ارسال آن در سیستم ثبت نشده است. لطفا با دکمه 'ارسال مجدد کد' درخواست کد جدید کنید.", ['inline_keyboard' => [[['text' => '🔄 ارسال مجدد کد', 'callback_data' => buildCallbackData('resendOtp')]]]], $platform);
        return; 
    }

    if ($message_text === null || !preg_match('/^\d{5}$/', convertPersianToEnglishDigits($message_text))) {
         sendMessage($chat_id, "❌ کد تایید باید یک عدد ۵ رقمی باشد. لطفا کد تایید را وارد کنید.", null, $platform);
         return;
    }
    $input_otp = trim(convertPersianToEnglishDigits($message_text));

    if (time() - $otp_timestamp > OTP_EXPIRY_SECONDS) {
        sendMessage($chat_id, "❌ کد تایید منقضی شده است. لطفا از طریق دکمه 'ارسال مجدد کد' درخواست کد جدید کنید.", ['inline_keyboard' => [[['text' => '🔄 ارسال مجدد کد', 'callback_data' => buildCallbackData('resendOtp')]]]], $platform);
        return;
    }
    if ($input_otp === $expected_otp) {
        updateUserField($user_id, 'otp_code', null);
        updateUserField($user_id, 'otp_timestamp', null);
        
        updateUserStatus($user_id, 'awaiting_full_name'); 
        sendMessage($chat_id, "✅ کد تایید با موفقیت وارد شد.\n\n*مرحله بعد:* لطفا نام و نام خانوادگی خود را به صورت کامل (فارسی) وارد کنید:", ['remove_keyboard' => true], $platform); 

    } else {
        sendMessage($chat_id, "❌ کد تایید اشتباه است. لطفا کد ۵ رقمی صحیح را وارد کنید.", null, $platform);
    }
}
function handleResendOtp(int $chat_id, int $user_id, string $platform, ?string $user_phone, int $otp_timestamp, ?string $callback_query_id): void {
    if (empty($user_phone)) {
        if ($callback_query_id) { @apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: شماره موبایل یافت نشد.', 'show_alert' => true], $platform); }
        updateUserStatus($user_id, 'awaiting_phone');
        handleVerificationStep('awaiting_phone', null, $chat_id, $user_id, $platform, []);
        return;
    }
    $time_since_last_otp = time() - $otp_timestamp;
    if ($time_since_last_otp < OTP_RESEND_COOLDOWN_SECONDS) {
        $remaining_time = OTP_RESEND_COOLDOWN_SECONDS - $time_since_last_otp;
        
         $message = "❌ برای ارسال مجدد کد، باید {$remaining_time} ثانیه صبر کنید.";
        if ($callback_query_id) { 
            @apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => $message, 'show_alert' => true], $platform); 
        } else {
        
            sendMessage($chat_id, $message, null, $platform);
        }
        return;
    }
    $new_otp_code = generateOtpCode(); 
    $new_otp_timestamp = time();
    updateUserField($user_id, 'otp_code', $new_otp_code);
    updateUserField($user_id, 'otp_timestamp', $new_otp_timestamp); 
    $send_result = sendSmsOtp($user_phone, $new_otp_code); 
    if ($send_result['success']) {
        $message = "✅ کد تایید ۵ رقمی جدید به شماره شما ({$user_phone}) ارسال شد. لطفا آن را وارد کنید.";
 
        if ($callback_query_id) { 
            @apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'کد جدید ارسال شد.'], $platform);
        }
        sendMessage($chat_id, $message, ['inline_keyboard' => [[['text' => '🔄 ارسال مجدد کد', 'callback_data' => buildCallbackData('resendOtp')]]]], $platform);
    } else {
        $error_message = $send_result['message'] ?? 'خطای ناشناخته در ارسال پیامک.';
        $message = "❌ خطایی در ارسال کد تایید رخ داد: {$error_message}";
        if ($callback_query_id) { 
            
          @apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => '❌ خطای ارسال پیامک. لطفا با پشتیبانی تماس بگیرید.', 'show_alert' => true], $platform);
        }
        sendMessage($chat_id, $message, null, $platform);
    }
}
function generateOtpCode(): string {
    return str_pad(mt_rand(10000, 99999), 5, '0', STR_PAD_LEFT);
}
?>