<?php
if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}
function handlePhoneInput(array $message, int $chat_id, int $user_id, string $platform): void {
    global $user;
    if (!isset($message['contact']['phone_number'])) {
        $first_name = $message['from']['first_name'] ?? 'کاربر';
        sendMessage(
            $chat_id,
             "سلام {$first_name} عزیز!\nبرای استفاده از ربات، لطفا شماره موبایل خود را از طریق دکمه زیر به اشتراک بگذارید.",
             ['keyboard' => [[['text' => '📱 اشتراک گذاری شماره موبایل', 'request_contact' => true]]], 'resize_keyboard' => true, 'one_time_keyboard' => true],
             $platform
        );
        return;
    }
    $phone = normalizePhoneNumber($message['contact']['phone_number']);
    $platform_id = $message['from']['id'] ?? 0;
    if ($platform_id == 0) {
         sendMessage($chat_id, "خطا: امکان دریافت شناسه کاربری شما وجود ندارد. لطفا دوباره تلاش کنید.", ['remove_keyboard' => true], $platform);
         return;
    }
    $existing_user = getUserByPhoneNumber($phone);
    if ($existing_user) {
        $existing_user_id = $existing_user['id'];
        $current_temp_user_id = $user_id;
        if ($current_temp_user_id != $existing_user_id) {
            $user_id_column = ($platform === 'bale') ? 'bale_user_id' : 'telegram_user_id';
            $chat_id_column = ($platform === 'bale') ? 'bale_chat_id' : 'telegram_chat_id';
            error_log("HandlePhone: Linking {$platform} ID {$platform_id} (from temp user {$current_temp_user_id}) to existing user {$existing_user_id} for phone {$phone}.");
            $temp_user = getUserById($current_temp_user_id);
            if ($temp_user && isset($temp_user[$user_id_column]) && $temp_user[$user_id_column] == $platform_id) {
               if (!updateUserField($current_temp_user_id, $user_id_column, null)) {
                    error_log("HandlePhone: WARNING - Failed to nullify {$user_id_column} for temp user {$current_temp_user_id}. Update might fail.");
                 } else {
                     error_log("HandlePhone: Nullified {$user_id_column} for temp user {$current_temp_user_id}.");
                 }
            } else {
                 error_log("HandlePhone: WARNING - Temp user {$current_temp_user_id} not found or platform ID mismatch. Update might fail.");
            }
            $update1_success = updateUserField($existing_user_id, $user_id_column, $platform_id);
            $update2_success = updateUserField($existing_user_id, $chat_id_column, $chat_id);
            if (!$update1_success || !$update2_success) {
                 error_log("HandlePhone: ERROR - Failed to update {$user_id_column} or {$chat_id_column} for existing user {$existing_user_id}. DB Error: " . (pdo()->errorInfo()[2] ?? 'Unknown PDO error'));
              sendMessage($chat_id, "❌ خطایی در هنگام اتصال حساب شما رخ داد. لطفا دوباره تلاش کنید یا با پشتیبانی تماس بگیرید.", ['remove_keyboard' => true], $platform);
             return;
            } else {
               error_log("HandlePhone: Successfully updated platform/chat IDs for existing user {$existing_user_id}.");
            }
            try {
               $stmt = pdo()->prepare("DELETE FROM users WHERE id = ?");
                  if ($stmt->execute([$current_temp_user_id])) {
                      error_log("HandlePhone: Successfully deleted temporary user {$current_temp_user_id}.");
             } else {
                      error_log("HandlePhone: FAILED to delete temporary user {$current_temp_user_id}.");
                 }
            } catch (PDOException $e) {
                 if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - Error deleting temporary user {$current_temp_user_id} during account link: " . $e->getMessage() . "\n", FILE_APPEND); }
            }
            sendMessage($chat_id, "✅ حساب شما با شماره موبایل `{$phone}` یافت و همگام‌سازی شد! خوش آمدید.", ['remove_keyboard' => true], $platform);
             $updated_existing_user = getUserById($existing_user_id);
            if ($updated_existing_user && $updated_existing_user['is_admin']) {
                $keyboard_markup = getAdminMainMenuKeyboard();
                sendMessage($chat_id, "⚙️ پنل مدیریت برای شما فعال است.", $keyboard_markup, $platform);
            } else {
                $keyboard_markup = getCustomerMainMenuKeyboard($updated_existing_user);
                sendMessage($chat_id, "به فروشگاه ما خوش آمدید!", $keyboard_markup, $platform);
            }
        } else {
               error_log("HandlePhone: Warning - Temporary user ID {$current_temp_user_id} is the same as existing user ID {$existing_user_id}. No linking needed.");
             sendMessage($chat_id, "حساب شما قبلاً با این شماره مرتبط شده است.", ['remove_keyboard' => true], $platform);
              if ($existing_user['is_admin']) {
                $keyboard_markup = getAdminMainMenuKeyboard();
                sendMessage($chat_id, "⚙️ پنل مدیریت برای شما فعال است.", $keyboard_markup, $platform);
            } else {
                $keyboard_markup = getCustomerMainMenuKeyboard($existing_user);
                sendMessage($chat_id, "به فروشگاه ما خوش آمدید!", $keyboard_markup, $platform);
            }
        }
        return;
    } else {
        if (isAdminPhoneNumber($phone)) {
            updateUserField($user_id, 'phone_number', $phone);
            updateUserField($user_id, 'is_admin', 1);
            updateUserStatus($user_id, 'identity_verified');
            sendMessage($chat_id, "✅ خوش آمدید مدیر گرامی!", ['remove_keyboard' => true], $platform);
            $keyboard_markup = getAdminMainMenuKeyboard();
            sendMessage($chat_id, "⚙️ پنل مدیریت برای شما فعال شد.", $keyboard_markup, $platform);
        } else {
            
            sendMessage($chat_id, "⏳ در حال ارسال کد تایید، لطفا شکیبا باشید...", ['remove_keyboard' => true], $platform);
            
            $otp_code = generateOtpCode(); 
            $send_result = sendSmsOtp($phone, $otp_code);
            
            if ($send_result['success']) {
                updateUserField($user_id, 'phone_number', $phone);
                updateUserField($user_id, 'otp_code', $otp_code);
                updateUserField($user_id, 'otp_timestamp', time()); 
                updateUserStatus($user_id, 'awaiting_otp');
                sendMessage($chat_id, "✅ یک کد تایید ۵ رقمی به شماره `{$phone}` ارسال شد. لطفا آن را وارد کنید.", ['remove_keyboard' => true], $platform);
            } else {
                $error_msg = $send_result['message'] ?? 'خطای ناشناخته';
                if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - SMS OTP Send Failed for {$phone}: " . $error_msg . "\n", FILE_APPEND); }
                sendMessage($chat_id, "❌ خطا در ارسال پیامک تایید (" . $error_msg . "). لطفا دقایقی دیگر با ارسال دستور /start مجددا تلاش کنید.", ['remove_keyboard' => true], $platform);
            }
            return;
        }
        return;
    }
}
?>