<?php

if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}

function handleSelfieInput(array $message, int $chat_id, int $user_id, string $platform, array $user): void {

    if (isset($message['photo'])) {
        $photo_array = $message['photo'];
        $source_file_id = end($photo_array)['file_id'];

        sendMessage($chat_id, "⏳ در حال پردازش و ذخیره‌سازی امن تصویر سلفی شما...", null, $platform);

        $file_content = downloadFileContent($source_file_id, $platform);

        if ($file_content) {
            $encrypted_data = encryptFileData($file_content);
            unset($file_content);

            if ($encrypted_data) {
                if (updateUserField($user_id, 'selfie_data', $encrypted_data)) {
                    
                    updateUserStatus($user_id, 'awaiting_admin_selfie_approval');
                    sendMessage($chat_id, "📸 تصویر شما دریافت، به صورت امن ذخیره و برای بررسی به مدیر ارسال شد. لطفا منتظر تایید بمانید...", null, $platform);

                    $request_id = createPendingAdminRequest($user_id, 'selfie');
                    if ($request_id == 0) {
                         if(defined('ERROR_LOG_PATH')) file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - CRITICAL Error: Failed to create pending admin request record for user {$user_id}.\n", FILE_APPEND);
                         return;
                    }
                   
                    
                    $user_platform_id_for_admin = $user['telegram_user_id'] ?? $user['bale_user_id'] ?? $user_id;
                    $admin_message = "🛎 *درخواست تایید سلفی جدید*\n\n" .
                                   "کاربر: {$user['first_name']} (ID: `{$user_platform_id_for_admin}`)\n" .
                                   "شماره: `{$user['phone_number']}`\n" .
                                   "کدملی: `{$user['national_id_code']}`\n" .
                                   "تاریخ تولد: `{$user['birth_date']}`\n\n" .
                                   "لطفا از بخش «درخواست‌های در انتظار» پنل مدیریت اقدام کنید.";
                    
                    notifyAdmins($admin_message);

                } else {
                    sendMessage($chat_id, "❌ خطا در ذخیره‌سازی داده‌های سلفی در دیتابیس. لطفا دوباره ارسال کنید.", null, $platform);
                    if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - Selfie DB save failed for user {$user_id}.\n", FILE_APPEND); }
                }
            } else {
                sendMessage($chat_id, "❌ خطا در رمزنگاری تصویر سلفی. لطفا دوباره ارسال کنید.", null, $platform);
                if (defined('ERROR_LOG_PATH')) { file_put_contents(ERROR_LOG_PATH, date('Y-m-d H:i:s') . " - Selfie encryption failed for user {$user_id}.\n", FILE_APPEND); }
            }
        } else {
             sendMessage($chat_id, "❌ خطا در دانلود تصویر سلفی. (کد: 404)\n\nفایل ارسالی شما نامعتبر است یا منقضی شده است. لطفا یک عکس واضح و جدید (نه فوروارد شده) از سلفی خود ارسال کنید.", null, $platform);
        }
    } else {
        sendMessage($chat_id, "لطفا فقط تصویر سلفی خود را طبق توضیحات ارسال نمایید (همراه با قرارداد امضا شده و کارت ملی).", null, $platform);
    }
}
?>