<?php
if (basename(__FILE__) == basename($_SERVER['SCRIPT_FILENAME'])) {
    die('No direct script access allowed');
}
function sendVerificationPaymentRequest(int $chat_id, int $user_id, string $platform, string $user_phone): void {
    global $user;
    
    $is_partner_customer = (isset($user['referred_by_user_id']) && $user['referred_by_user_id'] !== null);
    $verification_amount_toman = $is_partner_customer ? '10000' : '32800';

    $verification_amount_rial = (int) bcmul($verification_amount_toman, '10', 0);
    $description = "پرداخت هزینه احراز هویت برای کاربر {$user_phone}";
    $order_result = createVerificationOrder($user_id, $verification_amount_toman, $description);
    if (!$order_result['success'] || empty($order_result['order_id'])) {
        sendMessage($chat_id, "❌ خطایی هنگام ایجاد فاکتور پرداخت رخ داد. لطفا دقایقی دیگر با /start مجددا تلاش کنید.", null, $platform);
        logUserActivity($user_id, 'verification_payment_order_failed', ['error' => $order_result['message'] ?? 'Unknown']);
        return;
    }
    $order_id = $order_result['order_id'];
    $payment_page_url = PAYMENT_PAGE_URL . '?order_id=' . $order_id; 
    $payment_message = "✅ فاکتور شما با مبلغ `" . number_format($verification_amount_toman) . "` تومان جهت احراز هویت صادر شد.\n\n"
               . "👇 لطفا برای هدایت به صفحه پرداخت روی دکمه زیر کلیک کنید:";
    $buttons = [
        [['text' => '💰 پرداخت هزینه احراز هویت', 'url' => $payment_page_url]],
        [['text' => '🔄 بررسی وضعیت پرداخت', 'callback_data' => buildCallbackData('checkVerificationPayment', ['oid' => $order_id])]]
    ];
    $reply_markup = ['inline_keyboard' => $buttons];
    sendMessage($chat_id, $payment_message, $reply_markup, $platform);
}
function checkVerificationPaymentStatus(int $chat_id, int $user_id, string $platform, int $order_id, ?string $callback_query_id): void {
    global $user;
    $order = getOrderDetails($order_id);
    if (!$order || $order['user_id'] != $user_id) {
        if ($callback_query_id) {
            apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'خطا: سفارش یافت نشد.', 'show_alert' => true], $platform);
        }
        return;
    }
    if ($order['status'] === 'processing') {
        if ($callback_query_id) {
            apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => '✅ پرداخت شما تایید شده است.', 'show_alert' => true], $platform);
        }
        
        $is_partner_customer = (isset($user['referred_by_user_id']) && $user['referred_by_user_id'] !== null);
        
        if ($is_partner_customer) {
            updateUserStatus($user_id, 'awaiting_national_id_code');
            sendMessage($chat_id, "✅ پرداخت شما با موفقیت تایید شد.\n\n*مرحله بعد:* لطفا کد ملی خود را (۱۰ رقمی و بدون خط تیره) وارد کنید.", null, $platform);
        } else {
            updateUserStatus($user_id, 'awaiting_birth_year');
            $keyboard_markup = buildBirthYearKeyboard('selectBirth'); 
            sendMessage($chat_id, "✅ پرداخت شما با موفقیت تایید شد.\n\n*مرحله بعد:* لطفا *سال* تولد خود را (۴ رقمی شمسی) از گزینه‌های زیر انتخاب کنید:", $keyboard_markup, $platform);
        }
    } else {
        if ($callback_query_id) {
            apiRequest('answerCallbackQuery', ['callback_query_id' => $callback_query_id, 'text' => 'پرداخت هنوز انجام نشده است. لطفا پرداخت را کامل کنید.', 'show_alert' => true], $platform);
        }
        $payment_page_url = PAYMENT_PAGE_URL . '?order_id=' . $order_id;
        $buttons = [
            [['text' => '💰 تلاش مجدد برای پرداخت', 'url' => $payment_page_url]],
            [['text' => '🔄 بررسی وضعیت پرداخت', 'callback_data' => buildCallbackData('checkVerificationPayment', ['oid' => $order_id])]]
        ];
        sendMessage($chat_id, "پرداخت شما هنوز تایید نشده است. لطفا از طریق دکمه زیر پرداخت را تکمیل کنید.", ['inline_keyboard' => $buttons], $platform);
    }
}
?>