<?php

$received_token = $_SERVER['HTTP_X_BRIDGE_TOKEN'] ?? '';


require_once __DIR__ . '/config.php';


if (!defined('BRIDGE_SECRET_TOKEN') || !hash_equals(BRIDGE_SECRET_TOKEN, $received_token)) {
    http_response_code(403);
    die('Access Denied: Invalid Token');
}

define('PLATFORM', 'telegram');
define('IS_BRIDGE_CALL', true);


$GLOBALS['config'] = [
    'BRIDGE_DOWNLOAD_URL' => 'https://bridge.khazaesafrron.ir/telegram_relay_downloader.php' //other
];



require_once __DIR__ . '/iran_cities.php';
require_once __DIR__ . '/src/Database/Connection.php';

require_once __DIR__ . '/src/Utils/DateTimeHelpers.php';
require_once __DIR__ . '/src/Utils/EncryptionHelpers.php';
require_once __DIR__ . '/src/Utils/FormattingHelpers.php';
require_once __DIR__ . '/src/Utils/GeneralHelpers.php';
require_once __DIR__ . '/src/Utils/KeyboardBuilders.php';
require_once __DIR__ . '/src/Utils/ValidationHelpers.php';

require_once __DIR__ . '/src/Database/AttributeQueries.php';
require_once __DIR__ . '/src/Database/BroadcastQueries.php';
require_once __DIR__ . '/src/Database/CardQueries.php';
require_once __DIR__ . '/src/Database/CartQueries.php';
require_once __DIR__ . '/src/Database/CategoryQueries.php';
require_once __DIR__ . '/src/Database/DiscountQueries.php';
require_once __DIR__ . '/src/Database/LogQueries.php';
require_once __DIR__ . '/src/Database/OrderQueries.php';
require_once __DIR__ . '/src/Database/PayoutQueries.php';
require_once __DIR__ . '/src/Database/PendingRequestsQueries.php';
require_once __DIR__ . '/src/Database/ProductQueries.php';
require_once __DIR__ . '/src/Database/TransactionQueries.php';
require_once __DIR__ . '/src/Database/UserQueries.php';
require_once __DIR__ . '/src/Database/VariationQueries.php';

require_once __DIR__ . '/src/Services/BotApiService.php';
require_once __DIR__ . '/src/Services/ExternalApiService.php';
require_once __DIR__ .
'/src/Services/FileTransferService.php';
require_once __DIR__ . '/src/Services/ZarinpalService.php';

require_once __DIR__ . '/src/Modules/Admin/Broadcast/StartBroadcast.php';

require_once __DIR__ . '/src/Modules/Admin/Category/ManageCategories.php';
require_once __DIR__ . '/src/Modules/Admin/Discount/AddDiscount.php';
require_once __DIR__ . '/src/Modules/Admin/Discount/ListDiscounts.php';
require_once __DIR__ . '/src/Modules/Admin/Order/CreateInvoice.php';
require_once __DIR__ . '/src/Modules/Admin/Order/ListOrders.php';
require_once __DIR__ . '/src/Modules/Admin/Order/SearchOrder.php';
require_once __DIR__ . '/src/Modules/Admin/Order/SetShippingFee.php';
require_once __DIR__ . '/src/Modules/Admin/Order/SetStatus.php';
require_once __DIR__ . '/src/Modules/Admin/Order/SetTrackingCode.php';
require_once __DIR__ . '/src/Modules/Admin/Order/ViewOrder.php';
require_once __DIR__ . '/src/Modules/Admin/Payouts/ApprovePayout.php';
require_once __DIR__ . '/src/Modules/Admin/Payouts/ListPayouts.php';
require_once __DIR__ . '/src/Modules/Admin/Payouts/ViewPayout.php';
require_once __DIR__ . '/src/Modules/Admin/Payouts/RejectPayout.php';
require_once __DIR__ . '/src/Modules/Admin/PendingRequests/ListRequests.php';
require_once __DIR__ . '/src/Modules/Admin/Product/AddProductSteps.php';
require_once __DIR__ . '/src/Modules/Admin/Product/DeleteProduct.php';
require_once __DIR__ . '/src/Modules/Admin/Product/EditProductSteps.php';
require_once __DIR__ . '/src/Modules/Admin/Product/ListProducts.php';
require_once __DIR__ . '/src/Modules/Admin/Product/ManageSteward.php';
require_once __DIR__ 
. '/src/Modules/Admin/User/ListUsers.php';
require_once __DIR__ . '/src/Modules/Admin/User/MessageUser.php';
require_once __DIR__ . '/src/Modules/Admin/User/SearchUser.php';
require_once __DIR__ . '/src/Modules/Admin/User/UserDetails.php';

require_once __DIR__ . '/src/Modules/Customer/Card/AddCardStep.php';
require_once __DIR__ . '/src/Modules/Customer/Card/DeleteCard.php';
require_once __DIR__ . '/src/Modules/Customer/Card/ListCards.php';
require_once __DIR__ . '/src/Modules/Customer/Cart/AddToCartSteps.php';
require_once __DIR__ . '/src/Modules/Customer/Cart/ClearCart.php';
require_once __DIR__ . '/src/Modules/Customer/Cart/RemoveCartItem.php';
require_once __DIR__ . '/src/Modules/Customer/Cart/UpdateCartQty.php';
require_once __DIR__ . '/src/Modules/Customer/Cart/ViewCart.php';
require_once __DIR__ . '/src/Modules/Customer/Checkout/AddressSteps.php';
require_once __DIR__ . '/src/Modules/Customer/Checkout/ConfirmAndPay.php';
require_once __DIR__ . '/src/Modules/Customer/Checkout/DiscountSteps.php';

require_once __DIR__ . '/src/Modules/Customer/Checkout/OrderNoteStep.php';
require_once __DIR__ . '/src/Modules/Customer/Checkout/SelectCard.php';
require_once __DIR__ . '/src/Modules/Customer/Checkout/StartCheckout.php';

require_once __DIR__ . '/src/Modules/Customer/General/MainMenu.php';
require_once __DIR__ . '/src/Modules/Customer/Order/ListOrders.php';
require_once __DIR__ . '/src/Modules/Customer/Order/ViewOrder.php';
require_once __DIR__ . '/src/Modules/Customer/Product/SearchProduct.php';
require_once __DIR__ . '/src/Modules/Customer/Product/ViewCategory.php';
require_once __DIR__ . '/src/Modules/Customer/Referral/ListPartnerOrders.php';
require_once __DIR__ . '/src/Modules/Customer/Referral/ManagePartnerProduct.php';
require_once __DIR__ . '/src/Modules/Customer/Referral/ManagePayouts.php';
require_once __DIR__ . '/src/Modules/Customer/Referral/ManageShop.php';
require_once __DIR__ . '/src/Modules/Customer/Referral/ViewPartnerCustomerOrder.php';

require_once __DIR__ . '/src/Modules/Verification/HandleBirthdate.php';
require_once __DIR__ . '/src/Modules/Verification/HandleFullName.php';
require_once __DIR__ . '/src/Modules/Verification/HandleNationalIdCode.php';
require_once __DIR__ . '/src/Modules/Verification/HandleNationalIdPhoto.php';

require_once __DIR__ . '/src/Modules/Verification/HandleOtp.php';
require_once __DIR__ . '/src/Modules/Verification/HandlePhone.php';
require_once __DIR__ . '/src/Modules/Verification/HandleRejection.php';
require_once __DIR__ . '/src/Modules/Verification/HandleSelfie.php';
require_once __DIR__ . '/src/Modules/Verification/HandleVerificationPayment.php';

$update_json = file_get_contents('php://input');

global $update; 
$update = json_decode($update_json, true); 

if (!$update) {
    http_response_code(400);
    die('Invalid JSON input');
}

$GLOBALS['bridge_api_actions'] = [];

require_once __DIR__ . '/src/Core/Kernel.php';

header('Content-Type: application/json');
echo json_encode(['actions' => 
$GLOBALS['bridge_api_actions'] ?? []]);

exit();
?>